/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4.management;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.jpa.hibernate4.management.HibernateDescriptions;
import org.jboss.as.jpa.hibernate4.management.SecondLevelCacheMetricsHandler;
import org.jboss.as.jpa.spi.PersistenceUnitServiceRegistry;
import org.jboss.dmr.ModelType;

public class SecondLevelCacheResourceDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition HIT_COUNT = new SimpleAttributeDefinitionBuilder("hit-count", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition MISS_COUNT = new SimpleAttributeDefinitionBuilder("miss-count", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition PUT_COUNT = new SimpleAttributeDefinitionBuilder("put-count", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition ELEMENT_COUNT_IN_MEMORY = new SimpleAttributeDefinitionBuilder("element-count-in-memory", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    private final PersistenceUnitServiceRegistry persistenceUnitRegistry;

    SecondLevelCacheResourceDefinition(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        super(PathElement.pathElement((String)"entity-cache"), HibernateDescriptions.getResourceDescriptionResolver("hibernate.statistics.second-level-cache"));
        this.persistenceUnitRegistry = persistenceUnitRegistry;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerMetric((AttributeDefinition)HIT_COUNT, (OperationStepHandler)SecondLevelCacheMetricsHandler.getHitCount(this.persistenceUnitRegistry));
        resourceRegistration.registerMetric((AttributeDefinition)MISS_COUNT, (OperationStepHandler)SecondLevelCacheMetricsHandler.getMissCount(this.persistenceUnitRegistry));
        resourceRegistration.registerMetric((AttributeDefinition)PUT_COUNT, (OperationStepHandler)SecondLevelCacheMetricsHandler.getPutCount(this.persistenceUnitRegistry));
        resourceRegistration.registerMetric((AttributeDefinition)ELEMENT_COUNT_IN_MEMORY, (OperationStepHandler)SecondLevelCacheMetricsHandler.getElementCountInMemory(this.persistenceUnitRegistry));
    }
}

