/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.transaction.TransactionManager;
import javax.validation.ValidatorFactory;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jpa.beanvalidation.ValidatorFactoryProvider;
import org.jboss.as.jpa.classloader.TempClassLoader;
import org.jboss.as.jpa.config.PersistenceUnitMetadata;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.processor.JPADeploymentMarker;
import org.jboss.as.jpa.service.PersistenceUnitService;
import org.jboss.as.jpa.transaction.TransactionLocal;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.txn.TransactionManagerService;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.inject.CastingInjector;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;

public class PersistenceUnitDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.jpa");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        this.handleWarDeployment(phaseContext);
        this.handleEarDeployment(phaseContext);
        this.handleJarDeployment(phaseContext);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void handleJarDeployment(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        PersistenceUnitMetadataHolder holder;
        ResourceRoot deploymentRoot;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!PersistenceUnitDeploymentProcessor.isEarDeployment(deploymentUnit) && !PersistenceUnitDeploymentProcessor.isWarDeployment(deploymentUnit) && JPADeploymentMarker.isJPADeployment(deploymentUnit) && (deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)) != null && (holder = (PersistenceUnitMetadataHolder)deploymentRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) != null && holder.getPersistenceUnits().size() > 0) {
            ArrayList<PersistenceUnitMetadataHolder> puList = new ArrayList<PersistenceUnitMetadataHolder>(1);
            puList.add(holder);
            log.trace((Object)("install persistence unit definition for jar " + deploymentRoot.getRootName()));
            this.addPuService(phaseContext, deploymentRoot, puList);
        }
    }

    private void handleWarDeployment(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (PersistenceUnitDeploymentProcessor.isWarDeployment(deploymentUnit) && JPADeploymentMarker.isJPADeployment(deploymentUnit)) {
            PersistenceUnitMetadataHolder holder;
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            ArrayList<PersistenceUnitMetadataHolder> puList = new ArrayList<PersistenceUnitMetadataHolder>(1);
            if (deploymentRoot != null && (holder = (PersistenceUnitMetadataHolder)deploymentRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) != null && holder.getPersistenceUnits().size() > 0) {
                puList.add(holder);
            }
            List resourceRoots = (List)deploymentUnit.getAttachment(Attachments.RESOURCE_ROOTS);
            assert (resourceRoots != null);
            for (ResourceRoot resourceRoot : resourceRoots) {
                if (!resourceRoot.getRoot().getLowerCaseName().endsWith(".jar") || (holder = (PersistenceUnitMetadataHolder)resourceRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) == null || holder.getPersistenceUnits().size() <= 0) continue;
                puList.add(holder);
            }
            log.trace((Object)("install persistence unit definitions for war " + deploymentRoot.getRootName()));
            this.addPuService(phaseContext, deploymentRoot, puList);
        }
    }

    private void handleEarDeployment(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (PersistenceUnitDeploymentProcessor.isEarDeployment(deploymentUnit) && JPADeploymentMarker.isJPADeployment(deploymentUnit)) {
            PersistenceUnitMetadataHolder holder;
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            ArrayList<PersistenceUnitMetadataHolder> puList = new ArrayList<PersistenceUnitMetadataHolder>(1);
            if (deploymentRoot != null && (holder = (PersistenceUnitMetadataHolder)deploymentRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) != null && holder.getPersistenceUnits().size() > 0) {
                puList.add(holder);
            }
            log.trace((Object)("install persistence unit definitions for ear " + deploymentRoot.getRootName()));
            this.addPuService(phaseContext, deploymentRoot, puList);
        }
    }

    private void addPuService(DeploymentPhaseContext phaseContext, ResourceRoot resourceRoot, ArrayList<PersistenceUnitMetadataHolder> puList) throws DeploymentUnitProcessingException {
        if (puList.size() > 0) {
            DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            HashSet<ServiceName> serviceDependencies = new HashSet<ServiceName>();
            if (module == null) {
                throw new DeploymentUnitProcessingException("Failed to get module attachment for " + phaseContext.getDeploymentUnit());
            }
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            ModuleClassLoader classLoader = module.getClassLoader();
            for (PersistenceUnitMetadataHolder holder : puList) {
                for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                    pu.setClassLoader((ClassLoader)classLoader);
                    pu.setTempClassloader((ClassLoader)((Object)new TempClassLoader(classLoader)));
                    if (pu.getJtaDataSourceName() != null) {
                        serviceDependencies.add(AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{pu.getJtaDataSourceName()}));
                    }
                    if (pu.getNonJtaDataSourceName() != null) {
                        serviceDependencies.add(AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{pu.getNonJtaDataSourceName()}));
                    }
                    try {
                        PersistenceUnitService service = new PersistenceUnitService(pu, resourceRoot);
                        Injector<TransactionManager> injector = new Injector<TransactionManager>(){

                            public void inject(TransactionManager value) throws InjectionException {
                                TransactionLocal.setTransactionManager(value);
                            }

                            public void uninject() {
                            }
                        };
                        HashMap<String, ValidatorFactory> properties = new HashMap<String, ValidatorFactory>();
                        properties.put("javax.persistence.validation.factory", ValidatorFactoryProvider.getInstance().getValidatorFactory());
                        this.addHibernateProps(properties);
                        ServiceName serviceName = PersistenceUnitService.getPUServiceName(pu);
                        serviceTarget.addService(serviceName, (Service)service).addDependencies(serviceDependencies).addDependency(TransactionManagerService.SERVICE_NAME, (Injector)new CastingInjector((Injector)injector, TransactionManager.class)).setInitialMode(ServiceController.Mode.ACTIVE).addInjection(service.getPropertiesInjector(), properties).install();
                        log.trace((Object)("added PersistenceUnitService for '" + serviceName + "'.  PU is ready for injector action. "));
                    }
                    catch (ServiceRegistryException e) {
                        throw new DeploymentUnitProcessingException("Failed to add persistence unit service for " + pu.getPersistenceUnitName(), (Throwable)e);
                    }
                }
            }
        }
    }

    private void addHibernateProps(Map properties) {
        properties.put("hibernate.transaction.manager_lookup_class", "org.jboss.as.jpa.hibernate.TransactionManagerLookup");
        properties.put("hibernate.jndi.java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        properties.put("hibernate.jndi.java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        properties.put("hibernate.id.new_generator_mappings", "true");
    }

    static boolean isEarDeployment(DeploymentUnit context) {
        return DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)context);
    }

    static boolean isWarDeployment(DeploymentUnit context) {
        return DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)context);
    }
}

