/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;
import org.jboss.as.jpa.container.EntityManagerMetadata;

public abstract class AbstractEntityManager
implements EntityManager {
    private static final long serialVersionUID = 3L;
    private final Map<Class, Object> extensions = new HashMap<Class, Object>();

    protected AbstractEntityManager(String puScopedName, boolean isExtendedPersistenceContext) {
        this.setMetadata(puScopedName, isExtendedPersistenceContext);
    }

    protected abstract EntityManager getEntityManager();

    protected abstract boolean isExtendedPersistenceContext();

    protected abstract boolean isInTx();

    private void setMetadata(String puScopedName, boolean isExtendedPersistenceContext) {
        if (this.extensions.get(EntityManagerMetadata.class) == null) {
            EntityManagerMetadata metadata = new EntityManagerMetadata();
            metadata.setScopedPuName(puScopedName);
            metadata.setTransactionScopedEntityManager(!isExtendedPersistenceContext);
            this.addExtension(EntityManagerMetadata.class, metadata);
        }
    }

    protected void addExtension(Class cls, Object extension) {
        this.extensions.put(cls, extension);
    }

    public <T> T unwrap(Class<T> cls) {
        Object x = this.extensions.get(cls);
        if (x != null) {
            return (T)x;
        }
        return (T)this.getEntityManager().unwrap(cls);
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return this.getEntityManager().createNamedQuery(name, resultClass);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return this.getEntityManager().createQuery(criteriaQuery);
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        return this.getEntityManager().createQuery(qlString, resultClass);
    }

    public void detach(Object entity) {
        this.getEntityManager().detach(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        Object result = this.getEntityManager().find(entityClass, primaryKey, properties);
        this.detachNonTxInvocation();
        return (T)result;
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        Object result = this.getEntityManager().find(entityClass, primaryKey, lockMode);
        this.detachNonTxInvocation();
        return (T)result;
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        Object result = this.getEntityManager().find(entityClass, primaryKey, lockMode, properties);
        this.detachNonTxInvocation();
        return (T)result;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.getEntityManager().getCriteriaBuilder();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.getEntityManager().getEntityManagerFactory();
    }

    public LockModeType getLockMode(Object entity) {
        return this.getEntityManager().getLockMode(entity);
    }

    public Metamodel getMetamodel() {
        return this.getEntityManager().getMetamodel();
    }

    public Map<String, Object> getProperties() {
        return this.getEntityManager().getProperties();
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.getEntityManager().lock(entity, lockMode, properties);
    }

    public void setProperty(String propertyName, Object value) {
        this.getEntityManager().setProperty(propertyName, value);
    }

    public void clear() {
        this.getEntityManager().clear();
    }

    public void close() {
        this.getEntityManager().close();
    }

    public boolean contains(Object entity) {
        return this.getEntityManager().contains(entity);
    }

    public Query createNamedQuery(String name) {
        return this.getEntityManager().createNamedQuery(name);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        return this.getEntityManager().createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.getEntityManager().createNativeQuery(sqlString, resultSetMapping);
    }

    public Query createNativeQuery(String sqlString) {
        return this.getEntityManager().createNativeQuery(sqlString);
    }

    public Query createQuery(String ejbqlString) {
        return this.getEntityManager().createQuery(ejbqlString);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.getEntityManager().find(entityClass, primaryKey);
    }

    public void flush() {
        this.getEntityManager().flush();
    }

    public Object getDelegate() {
        return this.getEntityManager().getDelegate();
    }

    public FlushModeType getFlushMode() {
        return this.getEntityManager().getFlushMode();
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        Object result = this.getEntityManager().getReference(entityClass, primaryKey);
        this.detachNonTxInvocation();
        return (T)result;
    }

    public EntityTransaction getTransaction() {
        return this.getEntityManager().getTransaction();
    }

    public boolean isOpen() {
        return this.getEntityManager().isOpen();
    }

    public void joinTransaction() {
        this.getEntityManager().joinTransaction();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.getEntityManager().lock(entity, lockMode);
    }

    public <T> T merge(T entity) {
        EntityManager em = this.getEntityManager();
        this.transactionIsRequired();
        return (T)em.merge(entity);
    }

    public void persist(Object entity) {
        EntityManager em = this.getEntityManager();
        this.transactionIsRequired();
        em.persist(entity);
    }

    public void refresh(Object entity) {
        EntityManager em = this.getEntityManager();
        this.transactionIsRequired();
        em.refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        EntityManager em = this.getEntityManager();
        this.transactionIsRequired();
        em.refresh(entity, properties);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        EntityManager em = this.getEntityManager();
        this.transactionIsRequired();
        em.refresh(entity, lockMode);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        EntityManager em = this.getEntityManager();
        this.transactionIsRequired();
        em.refresh(entity, lockMode, properties);
    }

    public void remove(Object entity) {
        EntityManager em = this.getEntityManager();
        this.transactionIsRequired();
        em.remove(entity);
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.getEntityManager().setFlushMode(flushMode);
    }

    private void detachNonTxInvocation() {
        if (!this.isExtendedPersistenceContext() && !this.isInTx()) {
            this.getEntityManager().clear();
        }
    }

    private void transactionIsRequired() {
        if (!this.isExtendedPersistenceContext() && !this.isInTx()) {
            throw new TransactionRequiredException("Transaction is required to perform this operation (either use a transaction or extended persistence context)");
        }
    }
}

