/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.injectors;

import java.util.HashSet;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.BindingSourceDescription;
import org.jboss.as.jpa.container.ExtendedEntityManager;
import org.jboss.as.jpa.container.NonTxEmCloser;
import org.jboss.as.jpa.container.SFSBCallStack;
import org.jboss.as.jpa.container.SFSBXPCMap;
import org.jboss.as.jpa.container.TransactionScopedEntityManager;
import org.jboss.as.jpa.service.PersistenceUnitService;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class PersistenceContextBindingSourceDescription
extends BindingSourceDescription {
    private final PersistenceContextType type;
    private final PersistenceContextJndiInjectable injectable;
    private final ServiceName puServiceName;
    private static final HashSet<String> skipEntityManagerCloseFor = new HashSet();

    public PersistenceContextBindingSourceDescription(PersistenceContextType type, Map properties, ServiceName puServiceName, DeploymentUnit deploymentUnit, String scopedPuName, String injectionTypeName) {
        this.type = type;
        this.injectable = new PersistenceContextJndiInjectable(puServiceName, deploymentUnit, this.type, properties, scopedPuName, injectionTypeName);
        this.puServiceName = puServiceName;
    }

    public void getResourceValue(BindingDescription referenceDescription, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) {
        serviceBuilder.addDependencies(new ServiceName[]{this.puServiceName});
        injector.inject((Object)this.injectable);
    }

    static {
        skipEntityManagerCloseFor.add("org.hibernate.Session");
    }

    private static final class PersistenceContextJndiInjectable
    implements ManagedReferenceFactory {
        private final ServiceName puServiceName;
        private final DeploymentUnit deploymentUnit;
        private final PersistenceContextType type;
        private final Map properties;
        private final String unitName;
        private final String injectionTypeName;
        private static final String ENTITY_MANAGER_CLASS = "javax.persistence.EntityManager";
        private static final Logger log = Logger.getLogger((String)"org.jboss.jpa");

        public PersistenceContextJndiInjectable(ServiceName puServiceName, DeploymentUnit deploymentUnit, PersistenceContextType type, Map properties, String unitName, String injectionTypeName) {
            this.puServiceName = puServiceName;
            this.deploymentUnit = deploymentUnit;
            this.type = type;
            this.properties = properties;
            this.unitName = unitName;
            this.injectionTypeName = injectionTypeName;
        }

        public ManagedReference getReference() {
            EntityManager entityManager;
            boolean isExtended;
            PersistenceUnitService service = (PersistenceUnitService)this.deploymentUnit.getServiceRegistry().getRequiredService(this.puServiceName).getValue();
            EntityManagerFactory emf = service.getEntityManagerFactory();
            if (this.type.equals((Object)PersistenceContextType.TRANSACTION)) {
                isExtended = false;
                entityManager = new TransactionScopedEntityManager(this.unitName, this.properties, emf);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("created new TransactionScopedEntityManager for unit name=" + this.unitName));
                }
            } else {
                isExtended = true;
                EntityManager entityManager1 = SFSBCallStack.findPersistenceContext(this.unitName);
                if (entityManager1 == null) {
                    entityManager1 = emf.createEntityManager(this.properties);
                    entityManager = new ExtendedEntityManager(this.unitName, entityManager1);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("created new ExtendedEntityManager for unit name=" + this.unitName));
                    }
                } else {
                    entityManager = entityManager1;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("inherited existing ExtendedEntityManager from SFSB invocation stack, unit name=" + this.unitName));
                    }
                }
                SFSBXPCMap.RegisterPersistenceContext(entityManager);
            }
            if (!ENTITY_MANAGER_CLASS.equals(this.injectionTypeName)) {
                Class<?> extensionClass;
                try {
                    extensionClass = this.getClass().getClassLoader().loadClass(this.injectionTypeName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("couldn't load " + this.injectionTypeName + " from JPA modules classloader", e);
                }
                boolean skipAutoCloseAfterUnwrap = skipEntityManagerCloseFor.contains(this.injectionTypeName);
                if (!skipAutoCloseAfterUnwrap && !isExtended) {
                    NonTxEmCloser.pushCall();
                }
                Object targetValueToInject = entityManager.unwrap(extensionClass);
                if (!skipAutoCloseAfterUnwrap && !isExtended) {
                    NonTxEmCloser.popCall();
                }
                return new ValueManagedReference((Value)new ImmediateValue(targetValueToInject));
            }
            return new ValueManagedReference((Value)new ImmediateValue((Object)entityManager));
        }
    }
}

