/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.interceptor;

import java.util.List;
import javax.persistence.EntityManager;
import org.jboss.as.ee.component.AbstractComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.jpa.container.ExtendedEntityManager;
import org.jboss.as.jpa.container.SFSBXPCMap;
import org.jboss.as.jpa.ejb3.SFSBContextHandleImpl;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class SFSBDestroyInterceptorFactory
implements InterceptorFactory {
    public Interceptor create(final InterceptorFactoryContext context) {
        return new Interceptor(){

            public Object processInvocation(InterceptorContext interceptorContext) throws Exception {
                StatefulSessionComponentInstance sfsb = (StatefulSessionComponentInstance)context.getContextData().get(AbstractComponent.COMPONENT_INSTANCE_KEY);
                SFSBContextHandleImpl sfsbContextHandle = new SFSBContextHandleImpl(sfsb);
                List<EntityManager> readyToClose = SFSBXPCMap.getINSTANCE().remove(sfsbContextHandle);
                if (readyToClose != null && readyToClose.size() > 0) {
                    for (EntityManager entityManager : readyToClose) {
                        if (entityManager instanceof ExtendedEntityManager) {
                            ((ExtendedEntityManager)entityManager).containerClose();
                            continue;
                        }
                        throw new RuntimeException("can only close SFSB XPC entity manager that are instances of ExtendedEntityManager" + entityManager.getClass().getName());
                    }
                }
                return interceptorContext.proceed();
            }
        };
    }
}

