/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.transaction;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.jpa.container.EntityManagerMetadata;
import org.jboss.as.jpa.container.EntityManagerUtil;
import org.jboss.logging.Logger;
import org.jboss.tm.TxUtils;

public class TransactionUtil {
    private static final TransactionUtil INSTANCE = new TransactionUtil();
    private static final Logger log = Logger.getLogger((String)"org.jboss.jpa");
    private static volatile TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private static volatile TransactionManager transactionManager;

    public static TransactionUtil getInstance() {
        return INSTANCE;
    }

    public static void setTransactionManager(TransactionManager tm) {
        if (transactionManager == null) {
            transactionManager = tm;
        }
    }

    public static TransactionManager getTransactionManager() {
        return transactionManager;
    }

    public static void setTransactionSynchronizationRegistry(TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        if (TransactionUtil.transactionSynchronizationRegistry == null) {
            TransactionUtil.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        }
    }

    public boolean isInTx() {
        Transaction tx = this.getTransaction();
        return tx != null && TxUtils.isActive((Transaction)tx);
    }

    public void registerExtendedUnderlyingWithTransaction(String scopedPuName, EntityManager xpc, EntityManager underlyingEntityManager) {
        this.registerSynchronization(xpc, scopedPuName, false);
        underlyingEntityManager.joinTransaction();
        this.putEntityManagerInTransactionRegistry(scopedPuName, xpc);
    }

    public void registerExtendedWithTransaction(String scopedPuName, EntityManager xpc) {
        this.registerSynchronization(xpc, scopedPuName, false);
        this.putEntityManagerInTransactionRegistry(scopedPuName, xpc);
        xpc.joinTransaction();
    }

    public EntityManager getTransactionScopedEntityManager(String puScopedName) {
        return this.getEntityManagerInTransactionRegistry(puScopedName);
    }

    public EntityManager getOrCreateTransactionScopedEntityManager(EntityManagerFactory emf, String scopedPuName, Map properties) {
        EntityManager entityManager = this.getEntityManagerInTransactionRegistry(scopedPuName);
        if (entityManager == null) {
            entityManager = EntityManagerUtil.createEntityManager(emf, properties);
            if (log.isDebugEnabled()) {
                log.debug((Object)(TransactionUtil.getEntityManagerDetails(entityManager) + ": created entity manager session " + this.getTransaction().toString()));
            }
            this.registerSynchronization(entityManager, scopedPuName, true);
            this.putEntityManagerInTransactionRegistry(scopedPuName, entityManager);
            entityManager.joinTransaction();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)(TransactionUtil.getEntityManagerDetails(entityManager) + ": reuse entity manager session already in tx" + this.getTransaction().toString()));
        }
        return entityManager;
    }

    private void registerSynchronization(EntityManager entityManager, String puScopedName, boolean closeEMAtTxEnd) {
        Transaction tx = this.getTransaction();
        try {
            tx.registerSynchronization((Synchronization)new SessionSynchronization(entityManager, tx, closeEMAtTxEnd, puScopedName));
        }
        catch (RollbackException e) {
            throw new RuntimeException(e);
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    private Transaction getTransaction() {
        try {
            return transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new IllegalStateException("An error occured while getting the transaction associated with the current thread: " + (Object)((Object)e));
        }
    }

    public static TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return transactionSynchronizationRegistry;
    }

    private static String currentThread() {
        return Thread.currentThread().getName();
    }

    private static String getEntityManagerDetails(EntityManager manager) {
        String result = TransactionUtil.currentThread() + ":";
        try {
            EntityManagerMetadata metadata = (EntityManagerMetadata)manager.unwrap(EntityManagerMetadata.class);
            if (metadata != null) {
                result = result + metadata.getPuName() + (metadata.isTransactionScopedEntityManager() ? " [XPC]" : " [transactional]");
            }
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        return result;
    }

    private EntityManager getEntityManagerInTransactionRegistry(String scopedPuName) {
        return (EntityManager)TransactionUtil.getTransactionSynchronizationRegistry().getResource((Object)scopedPuName);
    }

    private void putEntityManagerInTransactionRegistry(String scopedPuName, EntityManager entityManager) {
        TransactionUtil.getTransactionSynchronizationRegistry().putResource((Object)scopedPuName, (Object)entityManager);
    }

    private static class SessionSynchronization
    implements Synchronization {
        private EntityManager manager;
        private boolean closeAtTxCompletion;
        private String scopedPuName;

        public SessionSynchronization(EntityManager session, Transaction tx, boolean close, String scopedPuName) {
            this.manager = session;
            this.closeAtTxCompletion = close;
            this.scopedPuName = scopedPuName;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (this.closeAtTxCompletion) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(TransactionUtil.getEntityManagerDetails(this.manager) + ": closing entity managersession "));
                }
                this.manager.close();
            }
            TransactionUtil.getInstance().putEntityManagerInTransactionRegistry(this.scopedPuName, null);
        }
    }
}

