/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.injectors;

import java.util.HashSet;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.jpa.container.AbstractEntityManager;
import org.jboss.as.jpa.container.ExtendedEntityManager;
import org.jboss.as.jpa.container.NonTxEmCloser;
import org.jboss.as.jpa.container.SFSBCallStack;
import org.jboss.as.jpa.container.SFSBXPCMap;
import org.jboss.as.jpa.container.TransactionScopedEntityManager;
import org.jboss.as.jpa.service.PersistenceUnitService;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class PersistenceContextInjectionSource
extends InjectionSource {
    private final PersistenceContextType type;
    private final PersistenceContextJndiInjectable injectable;
    private final ServiceName puServiceName;
    private static final HashSet<String> skipEntityManagerCloseFor = new HashSet();

    public PersistenceContextInjectionSource(PersistenceContextType type, Map properties, ServiceName puServiceName, DeploymentUnit deploymentUnit, String scopedPuName, String injectionTypeName, SFSBXPCMap sfsbxpcMap, PersistenceUnitMetadata pu) {
        this.type = type;
        this.injectable = new PersistenceContextJndiInjectable(puServiceName, deploymentUnit, this.type, properties, scopedPuName, injectionTypeName, sfsbxpcMap, pu);
        this.puServiceName = puServiceName;
    }

    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        serviceBuilder.addDependencies(new ServiceName[]{this.puServiceName});
        injector.inject((Object)this.injectable);
    }

    public boolean equals(Object other) {
        if (other instanceof PersistenceContextInjectionSource) {
            PersistenceContextInjectionSource source = (PersistenceContextInjectionSource)((Object)other);
            return source.puServiceName.equals(this.puServiceName);
        }
        return false;
    }

    public int hashCode() {
        return this.puServiceName.hashCode();
    }

    static {
        skipEntityManagerCloseFor.add("org.hibernate.Session");
    }

    private static final class PersistenceContextJndiInjectable
    implements ManagedReferenceFactory {
        private final ServiceName puServiceName;
        private final DeploymentUnit deploymentUnit;
        private final PersistenceContextType type;
        private final Map properties;
        private final String unitName;
        private final String injectionTypeName;
        private final SFSBXPCMap sfsbxpcMap;
        private final PersistenceUnitMetadata pu;
        private static final String ENTITY_MANAGER_CLASS = "javax.persistence.EntityManager";
        private static final Logger log = Logger.getLogger((String)"org.jboss.jpa");

        public PersistenceContextJndiInjectable(ServiceName puServiceName, DeploymentUnit deploymentUnit, PersistenceContextType type, Map properties, String unitName, String injectionTypeName, SFSBXPCMap sfsbxpcMap, PersistenceUnitMetadata pu) {
            this.puServiceName = puServiceName;
            this.deploymentUnit = deploymentUnit;
            this.type = type;
            this.properties = properties;
            this.unitName = unitName;
            this.injectionTypeName = injectionTypeName;
            this.sfsbxpcMap = sfsbxpcMap;
            this.pu = pu;
        }

        public ManagedReference getReference() {
            AbstractEntityManager entityManager;
            boolean isExtended;
            PersistenceUnitService service = (PersistenceUnitService)this.deploymentUnit.getServiceRegistry().getRequiredService(this.puServiceName).getValue();
            EntityManagerFactory emf = service.getEntityManagerFactory();
            if (this.type.equals((Object)PersistenceContextType.TRANSACTION)) {
                isExtended = false;
                entityManager = new TransactionScopedEntityManager(this.unitName, this.properties, emf);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("created new TransactionScopedEntityManager for unit name=" + this.unitName));
                }
            } else {
                isExtended = true;
                EntityManager entityManager1 = SFSBCallStack.findPersistenceContext(this.unitName, this.sfsbxpcMap);
                if (entityManager1 == null) {
                    entityManager1 = emf.createEntityManager(this.properties);
                    entityManager = new ExtendedEntityManager(this.unitName, entityManager1);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("created new ExtendedEntityManager for unit name=" + this.unitName));
                    }
                } else {
                    entityManager = entityManager1;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("inherited existing ExtendedEntityManager from SFSB invocation stack, unit name=" + this.unitName));
                    }
                }
                SFSBXPCMap.registerPersistenceContext(entityManager);
                SFSBCallStack.extendedPersistenceContextCreated(this.unitName, entityManager);
            }
            if (!ENTITY_MANAGER_CLASS.equals(this.injectionTypeName)) {
                Class<?> extensionClass;
                try {
                    extensionClass = this.pu.getClassLoader().loadClass(this.injectionTypeName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("couldn't load " + this.injectionTypeName + " from JPA modules classloader", e);
                }
                boolean skipAutoCloseAfterUnwrap = skipEntityManagerCloseFor.contains(this.injectionTypeName);
                if (!skipAutoCloseAfterUnwrap && !isExtended) {
                    NonTxEmCloser.pushCall();
                }
                Object targetValueToInject = entityManager.unwrap(extensionClass);
                if (!skipAutoCloseAfterUnwrap && !isExtended) {
                    NonTxEmCloser.popCall();
                }
                return new ValueManagedReference((Value)new ImmediateValue(targetValueToInject));
            }
            return new ValueManagedReference((Value)new ImmediateValue((Object)entityManager));
        }
    }
}

