/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.deployers.AbstractDeploymentDescriptorBindingsProcessor;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.container.PersistenceUnitSearch;
import org.jboss.as.jpa.container.SFSBXPCMap;
import org.jboss.as.jpa.injectors.PersistenceContextInjectionSource;
import org.jboss.as.jpa.injectors.PersistenceUnitInjectionSource;
import org.jboss.as.jpa.processor.JPADeploymentMarker;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData;
import org.jboss.metadata.javaee.spec.PersistenceContextReferencesMetaData;
import org.jboss.metadata.javaee.spec.PersistenceUnitReferenceMetaData;
import org.jboss.metadata.javaee.spec.PersistenceUnitReferencesMetaData;
import org.jboss.metadata.javaee.spec.PropertiesMetaData;
import org.jboss.metadata.javaee.spec.PropertyMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;
import org.jboss.msc.service.ServiceName;

public class PersistenceRefProcessor
extends AbstractDeploymentDescriptorBindingsProcessor {
    protected List<BindingConfiguration> processDescriptorEntries(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, EEModuleDescription moduleDescription, ComponentDescription componentDescription, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        ArrayList<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
        bindings.addAll(this.getPersistenceUnitRefs(deploymentUnit, environment, classLoader, deploymentReflectionIndex, moduleDescription, componentDescription));
        bindings.addAll(this.getPersistenceContextRefs(deploymentUnit, environment, classLoader, deploymentReflectionIndex, moduleDescription, componentDescription));
        return bindings;
    }

    private List<BindingConfiguration> getPersistenceUnitRefs(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEModuleDescription moduleDescription, ComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        ArrayList<BindingConfiguration> bindingConfigurations = new ArrayList<BindingConfiguration>();
        if (environment.getEnvironment() == null) {
            return bindingConfigurations;
        }
        PersistenceUnitReferencesMetaData persistenceUnitRefs = environment.getEnvironment().getPersistenceUnitRefs();
        if (persistenceUnitRefs != null) {
            if (persistenceUnitRefs.size() > 0) {
                JPADeploymentMarker.mark(deploymentUnit);
            }
            for (PersistenceUnitReferenceMetaData puRef : persistenceUnitRefs) {
                String name = puRef.getName();
                String persistenceUnitName = puRef.getPersistenceUnitName();
                String lookup = puRef.getLookupName();
                if (!this.isEmpty(lookup) && !this.isEmpty(persistenceUnitName)) {
                    throw JpaMessages.MESSAGES.cannotSpecifyBoth("<lookup-name>", (Object)lookup, "persistence-unit-name", (Object)persistenceUnitName, "<persistence-unit-ref/>", (Object)componentDescription);
                }
                if (!name.startsWith("java:")) {
                    name = environment.getDefaultContext() + name;
                }
                LookupInjectionSource injectionSource = new LookupInjectionSource(name);
                this.processInjectionTargets(moduleDescription, componentDescription, applicationClasses, (InjectionSource)injectionSource, classLoader, deploymentReflectionIndex, (ResourceInjectionMetaData)puRef, EntityManagerFactory.class);
                BindingConfiguration bindingConfiguration = null;
                if (!this.isEmpty(lookup)) {
                    bindingConfiguration = new BindingConfiguration(name, (InjectionSource)new LookupInjectionSource(lookup));
                } else {
                    InjectionSource puBindingSource = this.getPersistenceUnitBindingSource(deploymentUnit, persistenceUnitName);
                    bindingConfiguration = new BindingConfiguration(name, puBindingSource);
                }
                bindingConfigurations.add(bindingConfiguration);
            }
        }
        return bindingConfigurations;
    }

    private List<BindingConfiguration> getPersistenceContextRefs(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEModuleDescription moduleDescription, ComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        PersistenceContextReferencesMetaData persistenceUnitRefs;
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        ArrayList<BindingConfiguration> bindingConfigurations = new ArrayList<BindingConfiguration>();
        RemoteEnvironment remoteEnvironment = environment.getEnvironment();
        if (remoteEnvironment == null) {
            return bindingConfigurations;
        }
        if (remoteEnvironment instanceof Environment && (persistenceUnitRefs = ((Environment)remoteEnvironment).getPersistenceContextRefs()) != null) {
            for (PersistenceContextReferenceMetaData puRef : persistenceUnitRefs) {
                String name = puRef.getName();
                String persistenceUnitName = puRef.getPersistenceUnitName();
                String lookup = puRef.getLookupName();
                if (!this.isEmpty(lookup) && !this.isEmpty(persistenceUnitName)) {
                    throw JpaMessages.MESSAGES.cannotSpecifyBoth("<lookup-name>", (Object)lookup, "persistence-unit-name", (Object)persistenceUnitName, "<persistence-context-ref/>", (Object)componentDescription);
                }
                if (!name.startsWith("java:")) {
                    name = environment.getDefaultContext() + name;
                }
                LookupInjectionSource injectionSource = new LookupInjectionSource(name);
                this.processInjectionTargets(moduleDescription, componentDescription, applicationClasses, (InjectionSource)injectionSource, classLoader, deploymentReflectionIndex, (ResourceInjectionMetaData)puRef, EntityManager.class);
                BindingConfiguration bindingConfiguration = null;
                if (!this.isEmpty(lookup)) {
                    bindingConfiguration = new BindingConfiguration(name, (InjectionSource)new LookupInjectionSource(lookup));
                } else if (!this.isEmpty(persistenceUnitName)) {
                    PropertiesMetaData properties = puRef.getProperties();
                    HashMap<String, String> map = new HashMap<String, String>();
                    if (properties != null) {
                        for (PropertyMetaData prop : properties) {
                            map.put(prop.getKey(), prop.getValue());
                        }
                    }
                    PersistenceContextType type = puRef.getPersistenceContextType() == null ? PersistenceContextType.TRANSACTION : puRef.getPersistenceContextType();
                    InjectionSource pcBindingSource = this.getPersistenceContextBindingSource(deploymentUnit, persistenceUnitName, type, map);
                    bindingConfiguration = new BindingConfiguration(name, pcBindingSource);
                }
                bindingConfigurations.add(bindingConfiguration);
            }
        }
        return bindingConfigurations;
    }

    private InjectionSource getPersistenceUnitBindingSource(DeploymentUnit deploymentUnit, String unitName) throws DeploymentUnitProcessingException {
        String searchName = this.isEmpty(unitName) ? null : unitName;
        PersistenceUnitMetadata pu = PersistenceUnitSearch.resolvePersistenceUnitSupplier(deploymentUnit, searchName);
        String scopedPuName = pu.getScopedPersistenceUnitName();
        ServiceName puServiceName = this.getPuServiceName(scopedPuName);
        return new PersistenceUnitInjectionSource(puServiceName, deploymentUnit, EntityManagerFactory.class.getName(), pu);
    }

    private InjectionSource getPersistenceContextBindingSource(DeploymentUnit deploymentUnit, String unitName, PersistenceContextType type, Map properties) throws DeploymentUnitProcessingException {
        PersistenceUnitMetadata pu = this.getPersistenceUnit(deploymentUnit, unitName);
        if (pu.getTransactionType() == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            throw JpaMessages.MESSAGES.cannotInjectResourceLocalEntityManager(unitName);
        }
        String scopedPuName = pu.getScopedPersistenceUnitName();
        ServiceName puServiceName = this.getPuServiceName(scopedPuName);
        return new PersistenceContextInjectionSource(type, properties, puServiceName, deploymentUnit, scopedPuName, EntityManager.class.getName(), SFSBXPCMap.getXpcMap(deploymentUnit), pu);
    }

    private PersistenceUnitMetadata getPersistenceUnit(DeploymentUnit deploymentUnit, String puName) throws DeploymentUnitProcessingException {
        PersistenceUnitMetadata pu = PersistenceUnitSearch.resolvePersistenceUnitSupplier(deploymentUnit, puName);
        if (null == pu) {
            throw new DeploymentUnitProcessingException(JpaMessages.MESSAGES.deploymentUnitNotFound(puName, deploymentUnit));
        }
        return pu;
    }

    private ServiceName getPuServiceName(String scopedPuName) throws DeploymentUnitProcessingException {
        return PersistenceUnitServiceImpl.getPUServiceName(scopedPuName);
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

