/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.subsystem;

import java.util.List;
import java.util.Locale;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.jpa.persistenceprovider.PersistenceProviderResolverImpl;
import org.jboss.as.jpa.processor.JPAAnnotationParseProcessor;
import org.jboss.as.jpa.processor.JPAClassFileTransformerProcessor;
import org.jboss.as.jpa.processor.JPADependencyProcessor;
import org.jboss.as.jpa.processor.JPAInterceptorProcessor;
import org.jboss.as.jpa.processor.PersistenceProviderProcessor;
import org.jboss.as.jpa.processor.PersistenceRefProcessor;
import org.jboss.as.jpa.processor.PersistenceUnitDeploymentProcessor;
import org.jboss.as.jpa.processor.PersistenceUnitParseProcessor;
import org.jboss.as.jpa.service.JPAService;
import org.jboss.as.jpa.subsystem.JPADescriptions;
import org.jboss.as.jpa.subsystem.PersistenceUnitRegistryImpl;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class JPASubSystemAdd
extends AbstractBoottimeAddStepHandler
implements DescriptionProvider {
    static final String OPERATION_NAME = "add";
    private ParametersValidator modelValidator = new ParametersValidator();
    private ParametersValidator runtimeValidator = new ParametersValidator();
    private final PersistenceUnitRegistryImpl persistenceUnitRegistry;

    static ModelNode getAddOperation(ModelNode address, ModelNode currentModel) {
        ModelNode addOp = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        addOp.get("default-datasource").set(currentModel.get("default-datasource"));
        return addOp;
    }

    public JPASubSystemAdd(PersistenceUnitRegistryImpl persistenceUnitRegistry) {
        this.modelValidator.registerValidator("default-datasource", (ParameterValidator)new StringLengthValidator(0, Integer.MAX_VALUE, false, true));
        this.runtimeValidator.registerValidator("default-datasource", (ParameterValidator)new StringLengthValidator(0, Integer.MAX_VALUE, false, false));
        this.persistenceUnitRegistry = persistenceUnitRegistry;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.modelValidator.validate(operation);
        ModelNode defaultDSNode = operation.require("default-datasource");
        model.get("default-datasource").set(defaultDSNode);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        this.runtimeValidator.validate(operation.resolve());
        boolean appclient = context.getProcessType() == ProcessType.APPLICATION_CLIENT;
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                PersistenceProviderResolverHolder.setPersistenceProviderResolver((PersistenceProviderResolver)PersistenceProviderResolverImpl.getInstance());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 12032, (DeploymentUnitProcessor)new PersistenceUnitParseProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 12288, (DeploymentUnitProcessor)new JPAAnnotationParseProcessor());
                processorTarget.addDeploymentProcessor(Phase.DEPENDENCIES, 4096, (DeploymentUnitProcessor)new JPADependencyProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 5632, (DeploymentUnitProcessor)new PersistenceRefProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 5664, (DeploymentUnitProcessor)new JPAClassFileTransformerProcessor());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 512, (DeploymentUnitProcessor)new JPAInterceptorProcessor());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 4629, (DeploymentUnitProcessor)new PersistenceProviderProcessor());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 4640, (DeploymentUnitProcessor)new PersistenceUnitDeploymentProcessor(JPASubSystemAdd.this.persistenceUnitRegistry));
            }
        }, OperationContext.Stage.RUNTIME);
        ModelNode defaultDSNode = operation.require("default-datasource");
        String dataSourceName = defaultDSNode.resolve().asString();
        ServiceTarget target = context.getServiceTarget();
        newControllers.add(JPAService.addService(target, dataSourceName, new ServiceListener[]{verificationHandler}));
    }

    public ModelNode getModelDescription(Locale locale) {
        return JPADescriptions.getSubsystemAdd(locale);
    }
}

