/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.container.EntityManagerMetadata;

public abstract class AbstractEntityManager
implements EntityManager {
    private final boolean isTraceEnabled = JpaLogger.ROOT_LOGGER.isTraceEnabled();
    private final Map<Class, Object> extensions = new HashMap<Class, Object>();

    protected AbstractEntityManager(String puScopedName, boolean isExtendedPersistenceContext) {
        this.setMetadata(puScopedName, isExtendedPersistenceContext);
    }

    protected abstract EntityManager getEntityManager();

    protected abstract boolean isExtendedPersistenceContext();

    protected abstract boolean isInTx();

    private void setMetadata(String puScopedName, boolean isExtendedPersistenceContext) {
        if (this.extensions.get(EntityManagerMetadata.class) == null) {
            EntityManagerMetadata metadata = new EntityManagerMetadata();
            metadata.setScopedPuName(puScopedName);
            metadata.setTransactionScopedEntityManager(!isExtendedPersistenceContext);
            this.addExtension(EntityManagerMetadata.class, metadata);
        }
    }

    protected void addExtension(Class cls, Object extension) {
        this.extensions.put(cls, extension);
    }

    public <T> T unwrap(Class<T> cls) {
        Object x = this.extensions.get(cls);
        if (x != null) {
            return (T)x;
        }
        return (T)this.getEntityManager().unwrap(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            TypedQuery typedQuery = this.getEntityManager().createNamedQuery(name, resultClass);
            return typedQuery;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createNamedQuery name '%s', resultClass '%s' took %dms", (Object)name, (Object)resultClass.getName(), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            TypedQuery typedQuery = this.getEntityManager().createQuery(criteriaQuery);
            return typedQuery;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createQuery took %dms", (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            TypedQuery typedQuery = this.getEntityManager().createQuery(qlString, resultClass);
            return typedQuery;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createQuery resultClass '%s' took %dms", (Object)resultClass.getName(), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(Object entity) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().detach(entity);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("detach entityClass '%s' took %dms", (Object)entity.getClass().getName(), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager underlyingEntityManager = this.getEntityManager();
            Object result = underlyingEntityManager.find(entityClass, primaryKey, properties);
            this.detachNonTxInvocation(underlyingEntityManager);
            Object object = result;
            return (T)object;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("find entityClass '%s' took %dms", (Object)entityClass.getName(), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager underlyingEntityManager = this.getEntityManager();
            Object result = underlyingEntityManager.find(entityClass, primaryKey, lockMode);
            this.detachNonTxInvocation(underlyingEntityManager);
            Object object = result;
            return (T)object;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("find entityClass '%s', lockMode '%s' took %dms", (Object)entityClass.getName(), (Object)AbstractEntityManager.getLockModeAsString(lockMode), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager underlyingEntityManager = this.getEntityManager();
            Object result = underlyingEntityManager.find(entityClass, primaryKey, lockMode, properties);
            this.detachNonTxInvocation(underlyingEntityManager);
            Object object = result;
            return (T)object;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("find entityClass '%s', lockMode '%s' took %dms", (Object)entityClass.getName(), (Object)AbstractEntityManager.getLockModeAsString(lockMode), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager underlyingEntityManager = this.getEntityManager();
            Object result = this.getEntityManager().find(entityClass, primaryKey);
            this.detachNonTxInvocation(underlyingEntityManager);
            Object object = result;
            return (T)object;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("find entityClass '%s' took %dms", (Object)entityClass.getName(), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CriteriaBuilder getCriteriaBuilder() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
            return criteriaBuilder;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getCriteriaBuilder took %dms", (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory getEntityManagerFactory() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManagerFactory entityManagerFactory = this.getEntityManager().getEntityManagerFactory();
            return entityManagerFactory;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getEntityManagerFactory took %dms", (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockModeType getLockMode(Object entity) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        LockModeType result = null;
        try {
            result = this.getEntityManager().getLockMode(entity);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getLockMode entityClass '%s', lockMode '%s'  took %dms", (Object)entity.getClass().getName(), (Object)AbstractEntityManager.getLockModeAsString(result), (Object)elapsed);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metamodel getMetamodel() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            Metamodel metamodel = this.getEntityManager().getMetamodel();
            return metamodel;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getMetamodel took %dms", (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProperties() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            Map map = this.getEntityManager().getProperties();
            return map;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getProperties took %dms", (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().lock(entity, lockMode, properties);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("lock entityClass '%s', lockMode '%s'  took %dms", (Object)entity.getClass().getName(), (Object)AbstractEntityManager.getLockModeAsString(lockMode), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String propertyName, Object value) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().setProperty(propertyName, value);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("setProperty took %dms", (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().clear();
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("clear took %dms", (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().close();
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("close took %dms", (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object entity) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            boolean bl = this.getEntityManager().contains(entity);
            return bl;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("contains '%s' took %dms", (Object)entity.getClass().getName(), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNamedQuery(String name) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            Query query = this.getEntityManager().createNamedQuery(name);
            return query;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createNamedQuery name '%s' took %dms", (Object)name, (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString, Class resultClass) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            Query query = this.getEntityManager().createNativeQuery(sqlString, resultClass);
            return query;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createNativeQuery resultClass '%s' took %dms", (Object)resultClass.getName(), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            Query query = this.getEntityManager().createNativeQuery(sqlString, resultSetMapping);
            return query;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createNativeQuery took %dms", (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            Query query = this.getEntityManager().createNativeQuery(sqlString);
            return query;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createNativeQuery took %dms", (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(String ejbqlString) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            Query query = this.getEntityManager().createQuery(ejbqlString);
            return query;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createQuery took %dms", (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().flush();
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("flush took %dms", (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDelegate() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            Object object = this.getEntityManager().getDelegate();
            return object;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getDelegate took %dms", (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushModeType getFlushMode() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            FlushModeType flushModeType = this.getEntityManager().getFlushMode();
            return flushModeType;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getFlushMode took %dms", (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager underlyingEntityManager = this.getEntityManager();
            Object result = this.getEntityManager().getReference(entityClass, primaryKey);
            this.detachNonTxInvocation(underlyingEntityManager);
            Object object = result;
            return (T)object;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getReference entityClass '%s' took %dms", (Object)entityClass.getName(), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityTransaction getTransaction() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityTransaction entityTransaction = this.getEntityManager().getTransaction();
            return entityTransaction;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getTransaction took %dms", (Object)elapsed);
            }
        }
    }

    public boolean isOpen() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        return this.getEntityManager().isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinTransaction() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().joinTransaction();
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("joinTransaction took %dms", (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().lock(entity, lockMode);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("lock entityClass '%s', lockMode '%s' took %dms", (Object)entity.getClass().getName(), (Object)AbstractEntityManager.getLockModeAsString(lockMode), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T merge(T entity) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.transactionIsRequired();
            Object object = this.getEntityManager().merge(entity);
            return (T)object;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("merge entityClass '%s' took %dms", (Object)entity.getClass().getName(), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(Object entity) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.transactionIsRequired();
            this.getEntityManager().persist(entity);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("persist entityClass '%s' took %dms", (Object)entity.getClass().getName(), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.transactionIsRequired();
            this.getEntityManager().refresh(entity);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("refresh entityClass '%s' took %dms", (Object)entity.getClass().getName(), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, Map<String, Object> properties) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.transactionIsRequired();
            this.getEntityManager().refresh(entity, properties);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("refresh entityClass '%s' took %dms", (Object)entity.getClass().getName(), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.transactionIsRequired();
            this.getEntityManager().refresh(entity, lockMode);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("refresh entityClass '%s', lockMode '%s' took %dms", (Object)entity.getClass().getName(), (Object)AbstractEntityManager.getLockModeAsString(lockMode), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.transactionIsRequired();
            this.getEntityManager().refresh(entity, lockMode, properties);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("refresh entityClass '%s', lockMode '%s' took %dms", (Object)entity.getClass().getName(), (Object)AbstractEntityManager.getLockModeAsString(lockMode), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object entity) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.transactionIsRequired();
            this.getEntityManager().remove(entity);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("remove entityClass '%s' took %dms", (Object)entity.getClass().getName(), (Object)elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushMode(FlushModeType flushMode) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().setFlushMode(flushMode);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("setFlushMode took %dms", (Object)elapsed);
            }
        }
    }

    protected void detachNonTxInvocation(EntityManager underlyingEntityManager) {
        if (!this.isExtendedPersistenceContext() && !this.isInTx()) {
            underlyingEntityManager.clear();
        }
    }

    private void transactionIsRequired() {
        if (!this.isExtendedPersistenceContext() && !this.isInTx()) {
            throw JpaMessages.MESSAGES.transactionRequired();
        }
    }

    private static String getLockModeAsString(LockModeType lockMode) {
        if (lockMode == null) {
            return "(null)";
        }
        switch (lockMode) {
            case OPTIMISTIC: {
                return "optimistic";
            }
            case OPTIMISTIC_FORCE_INCREMENT: {
                return "optimistic_force_increment";
            }
            case READ: {
                return "read";
            }
            case WRITE: {
                return "write";
            }
            case PESSIMISTIC_READ: {
                return "pessimistic_read";
            }
            case PESSIMISTIC_FORCE_INCREMENT: {
                return "pessimistic_force_increment";
            }
        }
        return "none";
    }
}

