/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.io.Serializable;
import javax.persistence.EntityManager;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.container.AbstractEntityManager;
import org.jboss.as.jpa.transaction.TransactionUtil;

public class ExtendedEntityManager
extends AbstractEntityManager
implements Serializable {
    private static final long serialVersionUID = 432435L;
    private EntityManager underlyingEntityManager;
    private String puScopedName;
    private boolean isInTx;

    public ExtendedEntityManager(String puScopedName, EntityManager underlyingEntityManager) {
        super(puScopedName, true);
        this.underlyingEntityManager = underlyingEntityManager;
        this.puScopedName = puScopedName;
    }

    @Override
    protected EntityManager getEntityManager() {
        this.isInTx = TransactionUtil.getInstance().isInTx();
        if (this.isInTx) {
            EntityManager existing = TransactionUtil.getInstance().getTransactionScopedEntityManager(this.puScopedName);
            if (existing != null && existing != this) {
                throw JpaMessages.MESSAGES.cannotUseExtendedPersistenceTransaction(this.puScopedName, existing, (EntityManager)this);
            }
            if (existing == null) {
                TransactionUtil.getInstance().registerExtendedUnderlyingWithTransaction(this.puScopedName, this, this.underlyingEntityManager);
            }
        }
        return this.underlyingEntityManager;
    }

    @Override
    protected boolean isExtendedPersistenceContext() {
        return true;
    }

    @Override
    protected boolean isInTx() {
        return this.isInTx;
    }

    @Override
    public void close() {
        throw JpaMessages.MESSAGES.cannotCloseContainerManagedEntityManager();
    }

    public void containerClose() {
        this.underlyingEntityManager.close();
    }

    public String toString() {
        return "ExtendedEntityManager [" + this.puScopedName + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedEntityManager that = (ExtendedEntityManager)o;
        if (!this.puScopedName.equals(that.puScopedName)) {
            return false;
        }
        return this.underlyingEntityManager.equals(that.underlyingEntityManager);
    }

    public int hashCode() {
        int result = this.underlyingEntityManager.hashCode();
        result = 31 * result + this.puScopedName.hashCode();
        return result;
    }
}

