/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.interceptor;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.container.ExtendedEntityManager;
import org.jboss.as.jpa.container.SFSBXPCMap;
import org.jboss.as.jpa.ejb3.SFSBContextHandleImpl;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class SFSBDestroyInterceptor
implements Interceptor {
    private final SFSBXPCMap sfsbxpcMap;

    private SFSBDestroyInterceptor(SFSBXPCMap sfsbxpcMap) {
        this.sfsbxpcMap = sfsbxpcMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext interceptorContext) throws Exception {
        try {
            Object object = interceptorContext.proceed();
            return object;
        }
        finally {
            StatefulSessionComponentInstance sfsb = (StatefulSessionComponentInstance)interceptorContext.getPrivateData(ComponentInstance.class);
            SFSBContextHandleImpl sfsbContextHandle = new SFSBContextHandleImpl((Serializable)sfsb);
            List<EntityManager> readyToClose = this.sfsbxpcMap.remove(sfsbContextHandle);
            if (readyToClose != null && readyToClose.size() > 0) {
                for (EntityManager entityManager : readyToClose) {
                    if (entityManager instanceof ExtendedEntityManager) {
                        ((ExtendedEntityManager)entityManager).containerClose();
                        continue;
                    }
                    throw JpaMessages.MESSAGES.cannotCloseNonExtendedEntityManager(entityManager.getClass().getName());
                }
            }
        }
    }

    public static class Factory
    implements InterceptorFactory {
        private final SFSBXPCMap sfsbxpcMap;

        public Factory(SFSBXPCMap sfsbxpcMap) {
            this.sfsbxpcMap = sfsbxpcMap;
        }

        public Interceptor create(InterceptorFactoryContext context) {
            return new SFSBDestroyInterceptor(this.sfsbxpcMap);
        }
    }
}

