/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.AddressSettingAdd;
import org.jboss.as.messaging.AddressSettingDefinition;
import org.jboss.dmr.ModelNode;

class AddressSettingsWriteHandler
extends AbstractWriteAttributeHandler<RevertHandback> {
    static final AddressSettingsWriteHandler INSTANCE = new AddressSettingsWriteHandler();

    protected AddressSettingsWriteHandler() {
        super((AttributeDefinition[])AddressSettingDefinition.ATTRIBUTES);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<RevertHandback> handbackHolder) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        HornetQServer server = AddressSettingAdd.getServer(context, operation);
        if (server != null) {
            ModelNode model = resource.getModel();
            final PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            AddressSettings settings = AddressSettingAdd.createSettings(context, model);
            final HierarchicalRepository repository = server.getAddressSettingsRepository();
            String match = address.getLastElement().getValue();
            final AddressSettings existingSettings = (AddressSettings)repository.getMatch(match);
            repository.addMatch(match, (Object)settings);
            if (existingSettings != null) {
                handbackHolder.setHandback((Object)new RevertHandback(){

                    @Override
                    public void doRevertUpdateToRuntime() {
                        repository.addMatch(address.getLastElement().getValue(), (Object)existingSettings);
                    }
                });
            }
        }
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, RevertHandback handback) throws OperationFailedException {
        if (handback != null) {
            handback.doRevertUpdateToRuntime();
        }
    }

    static interface RevertHandback {
        public void doRevertUpdateToRuntime();
    }
}

