/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hornetq.api.core.management.AddressControl;
import org.hornetq.core.server.management.ManagementService;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.ManagementUtil;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.SecurityRoleResource;
import org.jboss.dmr.ModelNode;

public class CoreAddressResource
implements Resource {
    private final String name;
    private final ManagementService managementService;

    public CoreAddressResource(String name, ManagementService managementService) {
        this.name = name;
        this.managementService = managementService;
    }

    public ModelNode getModel() {
        return new ModelNode();
    }

    public void writeModel(ModelNode newModel) {
        throw MessagingMessages.MESSAGES.immutableResource();
    }

    public boolean isModelDefined() {
        return false;
    }

    public boolean hasChild(PathElement element) {
        if ("security-role".equals(element.getKey())) {
            return this.hasSecurityRole(element);
        }
        return false;
    }

    public Resource getChild(PathElement element) {
        return this.hasSecurityRole(element) ? SecurityRoleResource.INSTANCE : null;
    }

    public Resource requireChild(PathElement element) {
        throw new Resource.NoSuchResourceException(element);
    }

    public boolean hasChildren(String childType) {
        return false;
    }

    public Resource navigate(PathAddress address) {
        return Resource.Tools.navigate((Resource)this, (PathAddress)address);
    }

    public Set<String> getChildTypes() {
        HashSet<String> result = new HashSet<String>();
        result.add("security-role");
        return result;
    }

    public Set<String> getChildrenNames(String childType) {
        if ("security-role".equals(childType)) {
            return this.getSecurityRoles();
        }
        return Collections.emptySet();
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if ("security-role".equals(childType)) {
            HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>();
            for (String name : this.getSecurityRoles()) {
                result.add(new SecurityRoleResource.SecuriyRoleResourceEntry(name));
            }
            return result;
        }
        return Collections.emptySet();
    }

    public void registerChild(PathElement address, Resource resource) {
        throw MessagingMessages.MESSAGES.immutableResource();
    }

    public Resource removeChild(PathElement address) {
        throw MessagingMessages.MESSAGES.immutableResource();
    }

    public boolean isRuntime() {
        return true;
    }

    public boolean isProxy() {
        return false;
    }

    public Resource clone() {
        return new CoreAddressResource(this.name, this.managementService);
    }

    private Set<String> getSecurityRoles() {
        AddressControl addressControl = this.getAddressControl();
        if (addressControl == null) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        try {
            ModelNode res = ModelNode.fromJSONString((String)addressControl.getRolesAsJSON());
            ModelNode converted = ManagementUtil.convertSecurityRole(res);
            for (ModelNode role : converted.asList()) {
                names.add(role.get("name").asString());
            }
            return names;
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }

    private AddressControl getAddressControl() {
        if (this.managementService == null) {
            return null;
        }
        Object obj = this.managementService.getResource("core.address." + this.name);
        AddressControl control = (AddressControl)AddressControl.class.cast(obj);
        return control;
    }

    private boolean hasSecurityRole(PathElement element) {
        String role = element.getValue();
        return this.getSecurityRoles().contains(role);
    }

    public static class CoreAddressResourceEntry
    extends CoreAddressResource
    implements Resource.ResourceEntry {
        final PathElement path;
        private final ManagementService managementService2;

        public CoreAddressResourceEntry(String name, ManagementService managementService) {
            super(name, managementService);
            this.managementService2 = managementService;
            this.path = PathElement.pathElement((String)"core-address", (String)name);
        }

        public String getName() {
            return this.path.getValue();
        }

        public PathElement getPathElement() {
            return this.path;
        }

        @Override
        public CoreAddressResourceEntry clone() {
            return new CoreAddressResourceEntry(this.path.getValue(), this.managementService2);
        }
    }
}

