/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.regex.Pattern;

public class ChildFirstClassLoader
extends URLClassLoader {
    private final ClassLoader parent;
    private final List<Pattern> parentFirst;
    private final List<Pattern> childFirst;

    ChildFirstClassLoader(ClassLoader parent, List<Pattern> parentFirst, List<Pattern> childFirst, URL ... urls) {
        super(urls, parent);
        assert (parent != null) : "Null parent";
        assert (parentFirst != null) : "Null parent first";
        assert (childFirst != null) : "Null child first";
        this.parent = parent;
        this.childFirst = childFirst;
        this.parentFirst = parentFirst;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.loadFromParentOnly(name)) {
            return this.parent.loadClass(name);
        }
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (c == null) {
                c = this.parent.loadClass(name);
            }
            if (c == null) {
                this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url != null) {
            return url;
        }
        return super.getResource(name);
    }

    private boolean loadFromParentOnly(String className) {
        boolean parent = false;
        for (Pattern pattern : this.parentFirst) {
            if (!pattern.matcher(className).matches()) continue;
            parent = true;
            break;
        }
        if (parent) {
            for (Pattern pattern : this.childFirst) {
                if (!pattern.matcher(className).matches()) continue;
                return false;
            }
        }
        return parent;
    }

    public static void main(String[] args) {
        Pattern pattern = Pattern.compile("org\\.jboss\\.as\\.core\\.model\\.adapter\\.common\\..*");
        System.out.println(pattern);
        String className = "org.jboss.as.core.model.adapter.common.BLah";
        System.out.println(className);
        System.out.println(pattern.matcher(className).matches());
    }
}

