/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.as.model.test.ChildFirstClassLoader;
import org.jboss.as.model.test.MavenUtil;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.xnio.IoUtils;

public class ChildFirstClassLoaderBuilder {
    private List<URL> classloaderURLs = new ArrayList<URL>();
    private List<Pattern> parentFirst = new ArrayList<Pattern>();
    private List<Pattern> childFirst = new ArrayList<Pattern>();

    public ChildFirstClassLoaderBuilder addURL(URL url) {
        this.classloaderURLs.add(url);
        return this;
    }

    public ChildFirstClassLoaderBuilder addSimpleResourceURL(String resource) throws MalformedURLException {
        URL url = ChildFirstClassLoader.class.getResource(resource);
        if (url == null) {
            File file;
            ClassLoader cl = ChildFirstClassLoader.class.getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            if ((url = cl.getResource(resource)) == null && (file = new File(resource)).exists()) {
                url = file.toURI().toURL();
            }
        }
        if (url == null) {
            throw new IllegalArgumentException("Could not find resource " + resource);
        }
        this.classloaderURLs.add(url);
        return this;
    }

    public ChildFirstClassLoaderBuilder addMavenResourceURL(String artifactGav) throws MalformedURLException {
        this.classloaderURLs.add(MavenUtil.createMavenGavURL(artifactGav));
        return this;
    }

    public ChildFirstClassLoaderBuilder addRecursiveMavenResourceURL(String artifactGav) throws MalformedURLException, DependencyCollectionException, DependencyResolutionException {
        this.classloaderURLs.addAll(MavenUtil.createMavenGavRecursiveURLs(artifactGav));
        return this;
    }

    public ChildFirstClassLoaderBuilder addParentFirstClassPattern(String pattern) {
        this.parentFirst.add(this.compilePattern(pattern));
        return this;
    }

    public ChildFirstClassLoaderBuilder addChildFirstClassPattern(String pattern) {
        this.childFirst.add(this.compilePattern(pattern));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChildFirstClassLoaderBuilder createFromFile(File inputFile) {
        try {
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(inputFile)));
            try {
                this.classloaderURLs = (List)in.readObject();
            }
            finally {
                IoUtils.safeClose((Closeable)in);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public ClassLoader build() {
        return this.build(null);
    }

    public ClassLoader build(File outputFile) {
        if (outputFile != null) {
            this.outputSetupToFile(outputFile);
        }
        ClassLoader parent = this.getClass().getClassLoader() != null ? this.getClass().getClassLoader() : null;
        return new ChildFirstClassLoader(parent, this.parentFirst, this.childFirst, this.classloaderURLs.toArray(new URL[this.classloaderURLs.size()]));
    }

    private Pattern compilePattern(String pattern) {
        return Pattern.compile(pattern.replace(".", "\\.").replace("*", ".*"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputSetupToFile(File outputFile) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
            try {
                out.writeObject(this.classloaderURLs);
            }
            finally {
                IoUtils.safeClose((Closeable)out);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

