/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.deployment;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.as.naming.deployment.DuplicateBindingException;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentUnit;

public class NamespaceBindings {
    public static final AttachmentKey<NamespaceBindings> ATTACHMENT_KEY = AttachmentKey.create(NamespaceBindings.class);
    private final ConcurrentMap<JndiName, Object> bindings = new ConcurrentHashMap<JndiName, Object>();

    public static NamespaceBindings getNamespaceBindings(DeploymentUnit context) {
        NamespaceBindings namespaceBindings = (NamespaceBindings)context.getAttachment(ATTACHMENT_KEY);
        if (namespaceBindings == null) {
            namespaceBindings = new NamespaceBindings();
            context.putAttachment(ATTACHMENT_KEY, (Object)namespaceBindings);
        }
        return namespaceBindings;
    }

    public boolean addBinding(JndiName name, Object value) throws DuplicateBindingException {
        Object existing = this.bindings.putIfAbsent(name, value);
        if (existing != null && !existing.equals(value)) {
            StringBuilder builder = new StringBuilder("Duplicate JNDI bindings for '").append(name).append("' are not compatible.  [").append(existing).append("] != [").append(value).append("]");
            throw new DuplicateBindingException(builder.toString());
        }
        return existing == null;
    }
}

