/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.service.BinderService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class BindingHandleService
implements Service<Void> {
    private final InjectedValue<ManagedReferenceFactory> managedReferenceFactory = new InjectedValue();
    private final BinderService binder;
    private final ServiceName binderName;
    private final String name;
    private final ServiceVerificationHandler serviceVerificationHandler;
    private AcquireOnStart acquireOnStart;
    private ServiceName namingStoreName;

    public BindingHandleService(String name, ServiceName binderName, Object source, ServiceName namingStoreName, ServiceVerificationHandler serviceVerificationHandler) {
        this.binderName = binderName;
        this.name = name;
        this.serviceVerificationHandler = serviceVerificationHandler;
        this.binder = new BinderService(name, source);
        this.namingStoreName = namingStoreName;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.acquireOnStart = new AcquireOnStart();
        ServiceController controller = context.getController();
        try {
            ServiceBuilder serviceBuilder = context.getController().getServiceContainer().addService(this.binderName, (Service)this.binder);
            serviceBuilder.addDependency(this.namingStoreName, NamingStore.class, this.binder.getNamingStoreInjector());
            serviceBuilder.addInjectionValue(this.binder.getManagedObjectInjector(), this.managedReferenceFactory);
            serviceBuilder.addListener((ServiceListener)this.acquireOnStart);
            serviceBuilder.addListener((ServiceListener)this.serviceVerificationHandler);
            serviceBuilder.install();
        }
        catch (RuntimeException e) {
            ServiceController registered = controller.getServiceContainer().getService(this.binderName);
            if (registered == null) {
                throw e;
            }
            BinderService service = (BinderService)registered.getService();
            if (!service.getSource().equals(this.binder.getSource())) {
                throw new IllegalArgumentException("Incompatible conflicting binding at " + this.name + " source: " + this.binder.getSource());
            }
            registered.addListener((ServiceListener)this.acquireOnStart);
        }
    }

    public synchronized void stop(StopContext context) {
        ServiceController registered = context.getController().getServiceContainer().getService(this.binderName);
        if (registered == null) {
            return;
        }
        BinderService service = (BinderService)registered.getService();
        if (!this.acquireOnStart.abort()) {
            service.release();
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    public Injector<ManagedReferenceFactory> getManagedObjectInjector() {
        return this.managedReferenceFactory;
    }

    private static class AcquireOnStart
    implements ServiceListener<ManagedReferenceFactory> {
        private boolean acquired = false;

        private AcquireOnStart() {
        }

        public synchronized void listenerAdded(ServiceController<? extends ManagedReferenceFactory> serviceController) {
            if (!this.acquired && serviceController.getSubstate() == ServiceController.Substate.UP) {
                ((BinderService)serviceController.getService()).acquire();
                this.acquired = true;
            }
        }

        public synchronized boolean abort() {
            if (!this.acquired) {
                return true;
            }
            this.acquired = false;
            return false;
        }

        public synchronized void transition(ServiceController<? extends ManagedReferenceFactory> serviceController, ServiceController.Transition transition) {
            if (!this.acquired && transition == ServiceController.Transition.STARTING_to_UP) {
                ((BinderService)serviceController.getService()).acquire();
                this.acquired = true;
            }
        }

        public void serviceRemoveRequested(ServiceController<? extends ManagedReferenceFactory> serviceController) {
        }

        public void serviceRemoveRequestCleared(ServiceController<? extends ManagedReferenceFactory> serviceController) {
        }

        public void dependencyFailed(ServiceController<? extends ManagedReferenceFactory> serviceController) {
        }

        public void dependencyFailureCleared(ServiceController<? extends ManagedReferenceFactory> serviceController) {
        }

        public void immediateDependencyUnavailable(ServiceController<? extends ManagedReferenceFactory> serviceController) {
        }

        public void immediateDependencyAvailable(ServiceController<? extends ManagedReferenceFactory> serviceController) {
        }

        public void transitiveDependencyUnavailable(ServiceController<? extends ManagedReferenceFactory> serviceController) {
        }

        public void transitiveDependencyAvailable(ServiceController<? extends ManagedReferenceFactory> serviceController) {
        }
    }
}

