/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.subsystem;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.naming.subsystem.NamingBindingResourceDefinition;
import org.jboss.as.naming.subsystem.NamingSubsystemNamespace;
import org.jboss.as.naming.subsystem.NamingSubsystemXMLAttribute;
import org.jboss.as.naming.subsystem.NamingSubsystemXMLElement;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class NamingSubsystem11Parser
implements XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    public static final NamingSubsystem11Parser INSTANCE = new NamingSubsystem11Parser();

    private NamingSubsystem11Parser() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement("urn:jboss:domain:naming:1.1", false);
        ModelNode model = context.getModelNode();
        if (model.hasDefined("binding")) {
            writer.writeStartElement(NamingSubsystemXMLElement.BINDINGS.getLocalName());
            ModelNode bindingModel = model.get("binding");
            this.writeBindings(writer, bindingModel);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeBindings(XMLExtendedStreamWriter writer, ModelNode bindingModel) throws XMLStreamException {
        for (Property binding : bindingModel.asPropertyList()) {
            String type = binding.getValue().get("binding-type").asString();
            if (type.equals("simple")) {
                this.writeSimpleBinding(binding, writer);
                continue;
            }
            if (type.equals("object-factory")) {
                this.writeObjectFactoryBinding(binding, writer);
                continue;
            }
            if (type.equals("lookup")) {
                this.writeLookupBinding(binding, writer);
                continue;
            }
            throw new XMLStreamException("Unknown binding type " + type);
        }
    }

    private void writeSimpleBinding(Property binding, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(NamingSubsystemXMLElement.SIMPLE.getLocalName());
        writer.writeAttribute(NamingSubsystemXMLAttribute.NAME.getLocalName(), binding.getName());
        writer.writeAttribute(NamingSubsystemXMLAttribute.VALUE.getLocalName(), binding.getValue().get("value").asString());
        if (binding.getValue().has("type")) {
            writer.writeAttribute(NamingSubsystemXMLAttribute.TYPE.getLocalName(), binding.getValue().get("type").asString());
        }
        writer.writeEndElement();
    }

    private void writeObjectFactoryBinding(Property binding, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(NamingSubsystemXMLElement.OBJECT_FACTORY.getLocalName());
        writer.writeAttribute(NamingSubsystemXMLAttribute.NAME.getLocalName(), binding.getName());
        writer.writeAttribute(NamingSubsystemXMLAttribute.MODULE.getLocalName(), binding.getValue().get("module").asString());
        writer.writeAttribute(NamingSubsystemXMLAttribute.CLASS.getLocalName(), binding.getValue().get("class").asString());
        writer.writeEndElement();
    }

    private void writeLookupBinding(Property binding, XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(NamingSubsystemXMLElement.LOOKUP.getLocalName());
        writer.writeAttribute(NamingSubsystemXMLAttribute.NAME.getLocalName(), binding.getName());
        writer.writeAttribute(NamingSubsystemXMLAttribute.LOOKUP.getLocalName(), binding.getValue().get("lookup").asString());
        writer.writeEndElement();
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode ejb3SubsystemAddOperation = new ModelNode();
        ejb3SubsystemAddOperation.get("operation").set("add");
        ejb3SubsystemAddOperation.get("address").add("subsystem", "naming");
        operations.add(ejb3SubsystemAddOperation);
        EnumSet<NamingSubsystemXMLElement> encountered = EnumSet.noneOf(NamingSubsystemXMLElement.class);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (NamingSubsystemNamespace.forUri(reader.getNamespaceURI())) {
                case NAMING_1_1: {
                    NamingSubsystemXMLElement element = NamingSubsystemXMLElement.forName(reader.getLocalName());
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case BINDINGS: {
                            this.parseBindings(reader, operations);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseBindings(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (NamingSubsystemXMLElement.forName(reader.getLocalName())) {
                case SIMPLE: {
                    this.parseSimpleBinding(reader, operations);
                    continue block5;
                }
                case OBJECT_FACTORY: {
                    this.parseObjectFactoryBinding(reader, operations);
                    continue block5;
                }
                case LOOKUP: {
                    this.parseLookupBinding(reader, operations);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSimpleBinding(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int attCount = reader.getAttributeCount();
        String name = null;
        String bindingValue = null;
        String type = null;
        EnumSet<NamingSubsystemXMLAttribute> required = EnumSet.of(NamingSubsystemXMLAttribute.NAME, NamingSubsystemXMLAttribute.VALUE);
        block5: for (int i = 0; i < attCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            NamingSubsystemXMLAttribute attribute = NamingSubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    continue block5;
                }
                case VALUE: {
                    bindingValue = NamingBindingResourceDefinition.VALUE.parse(value, (XMLStreamReader)reader).asString();
                    continue block5;
                }
                case TYPE: {
                    type = NamingBindingResourceDefinition.TYPE.parse(value, (XMLStreamReader)reader).asString();
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "naming");
        address.add("binding", name);
        ModelNode bindingAdd = new ModelNode();
        bindingAdd.get("operation").set("add");
        bindingAdd.get("address").set(address);
        bindingAdd.get("binding-type").set("simple");
        bindingAdd.get("value").set(bindingValue);
        if (type != null) {
            bindingAdd.get("type").set(type);
        }
        operations.add(bindingAdd);
    }

    private void parseObjectFactoryBinding(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int attCount = reader.getAttributeCount();
        String name = null;
        String module = null;
        String factory = null;
        EnumSet<NamingSubsystemXMLAttribute> required = EnumSet.of(NamingSubsystemXMLAttribute.NAME, NamingSubsystemXMLAttribute.MODULE, NamingSubsystemXMLAttribute.CLASS);
        block5: for (int i = 0; i < attCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            NamingSubsystemXMLAttribute attribute = NamingSubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    continue block5;
                }
                case MODULE: {
                    module = NamingBindingResourceDefinition.MODULE.parse(value, (XMLStreamReader)reader).asString();
                    continue block5;
                }
                case CLASS: {
                    factory = NamingBindingResourceDefinition.CLASS.parse(value, (XMLStreamReader)reader).asString();
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "naming");
        address.add("binding", name);
        ModelNode bindingAdd = new ModelNode();
        bindingAdd.get("operation").set("add");
        bindingAdd.get("address").set(address);
        bindingAdd.get("binding-type").set("object-factory");
        bindingAdd.get("module").set(module);
        bindingAdd.get("class").set(factory);
        operations.add(bindingAdd);
    }

    private void parseLookupBinding(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int attCount = reader.getAttributeCount();
        String name = null;
        String lookup = null;
        EnumSet<NamingSubsystemXMLAttribute> required = EnumSet.of(NamingSubsystemXMLAttribute.NAME, NamingSubsystemXMLAttribute.LOOKUP);
        block4: for (int i = 0; i < attCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            NamingSubsystemXMLAttribute attribute = NamingSubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    continue block4;
                }
                case LOOKUP: {
                    lookup = NamingBindingResourceDefinition.LOOKUP.parse(value, (XMLStreamReader)reader).asString();
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "naming");
        address.add("binding", name);
        ModelNode bindingAdd = new ModelNode();
        bindingAdd.get("operation").set("add");
        bindingAdd.get("address").set(address);
        bindingAdd.get("binding-type").set("lookup");
        bindingAdd.get("lookup").set(lookup);
        operations.add(bindingAdd);
    }
}

