/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.configadmin;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.apache.felix.cm.PersistenceManager;
import org.jboss.as.configadmin.service.ConfigAdminListener;
import org.jboss.as.configadmin.service.ConfigAdminService;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class DomainModelPersistenceManager
implements PersistenceManager,
BundleActivator,
ConfigAdminListener {
    private ConfigAdminService jbossConfigAdminService;
    private ServiceTracker osgiConfigAdminServiceTracker;
    private ServiceRegistration serviceRegistration;

    public void start(BundleContext context) throws Exception {
        ServiceReference sref = context.getServiceReference(ServiceContainer.class.getName());
        ServiceContainer serviceContainer = (ServiceContainer)context.getService(sref);
        ServiceController controller = serviceContainer.getRequiredService(ConfigAdminService.SERVICE_NAME);
        this.jbossConfigAdminService = (ConfigAdminService)controller.getValue();
        this.jbossConfigAdminService.addListener((ConfigAdminListener)this);
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        props.put("service.ranking", Integer.MAX_VALUE);
        this.serviceRegistration = context.registerService(PersistenceManager.class.getName(), (Object)this, props);
        this.osgiConfigAdminServiceTracker = new ServiceTracker(context, ConfigurationAdmin.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                Object svc = super.addingService(reference);
                if (svc instanceof ConfigurationAdmin) {
                    ConfigurationAdmin osgiConfigAdminService = (ConfigurationAdmin)svc;
                    for (String pid : DomainModelPersistenceManager.this.jbossConfigAdminService.getConfigurations()) {
                        try {
                            osgiConfigAdminService.getConfiguration(pid, null);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                return svc;
            }
        };
        this.osgiConfigAdminServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.serviceRegistration.unregister();
        this.jbossConfigAdminService.removeListener((ConfigAdminListener)this);
        this.jbossConfigAdminService = null;
        this.osgiConfigAdminServiceTracker.close();
    }

    public boolean exists(String pid) {
        return this.jbossConfigAdminService.hasConfiguration(pid);
    }

    public Dictionary<String, String> load(String pid) throws IOException {
        Dictionary props = this.jbossConfigAdminService.getConfiguration(pid);
        return this.addStandardProperties(pid, props);
    }

    public Enumeration<Dictionary<String, String>> getDictionaries() throws IOException {
        Vector<Dictionary<String, String>> result = new Vector<Dictionary<String, String>>();
        for (String pid : this.jbossConfigAdminService.getConfigurations()) {
            Dictionary props = this.jbossConfigAdminService.getConfiguration(pid);
            result.add(this.addStandardProperties(pid, props));
        }
        return result.elements();
    }

    public void store(String pid, Dictionary source) throws IOException {
        if ("fromdmr".equals(source.get(".org.jboss.source"))) {
            return;
        }
        Hashtable<String, String> copy = new Hashtable<String, String>();
        if (source != null) {
            Enumeration keys = source.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                ((Dictionary)copy).put(key, source.get(key).toString());
            }
        }
        this.jbossConfigAdminService.putConfiguration(pid, copy);
    }

    public void delete(String pid) throws IOException {
        this.jbossConfigAdminService.removeConfiguration(pid);
    }

    private Dictionary<String, String> addStandardProperties(String pid, Dictionary<String, String> source) {
        Dictionary<String, String> copy = this.getModifiableDictionary(source);
        copy.put("service.pid", pid);
        return copy;
    }

    private Dictionary<String, String> getModifiableDictionary(Dictionary<String, String> source) {
        Hashtable<String, String> copy = new Hashtable<String, String>();
        if (source != null) {
            Enumeration<String> keys = source.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                ((Dictionary)copy).put(key, source.get(key));
            }
        }
        return copy;
    }

    public void configurationModified(String pid, Dictionary<String, String> dictionary) {
        ConfigurationAdmin osgiConfigAdminService = (ConfigurationAdmin)this.osgiConfigAdminServiceTracker.getService();
        if (osgiConfigAdminService == null) {
            return;
        }
        try {
            if (dictionary == null) {
                Configuration[] configs = osgiConfigAdminService.listConfigurations("(service.pid=" + pid + ")");
                if (configs != null) {
                    for (Configuration config : configs) {
                        config.delete();
                    }
                }
            } else if ("fromdmr".equals(dictionary.get(".org.jboss.source"))) {
                Configuration configuration = osgiConfigAdminService.getConfiguration(pid, null);
                configuration.update(dictionary);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getPIDs() {
        return null;
    }
}

