/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.osgi.service.UnmodifiableDictionary;
import org.jboss.modules.ModuleIdentifier;

public final class SubsystemState
implements Serializable {
    private static final long serialVersionUID = 6268537612248019022L;
    public static final String PROP_JBOSS_OSGI_SYSTEM_MODULES = "org.jboss.osgi.system.modules";
    private final Map<String, Dictionary<String, String>> configurations = new LinkedHashMap<String, Dictionary<String, String>>();
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final List<OSGiModule> modules = new ArrayList<OSGiModule>();
    private Activation activationPolicy = Activation.LAZY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getConfigurations() {
        Map<String, Dictionary<String, String>> map = this.configurations;
        synchronized (map) {
            Set<String> values = this.configurations.keySet();
            return Collections.unmodifiableSet(new HashSet<String>(values));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasConfiguration(String pid) {
        Map<String, Dictionary<String, String>> map = this.configurations;
        synchronized (map) {
            return this.configurations.containsKey(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary<String, String> getConfiguration(String pid) {
        Map<String, Dictionary<String, String>> map = this.configurations;
        synchronized (map) {
            return this.configurations.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary<String, String> putConfiguration(String pid, Dictionary<String, String> props) {
        Map<String, Dictionary<String, String>> map = this.configurations;
        synchronized (map) {
            return this.configurations.put(pid, new UnmodifiableDictionary<String, String>(props));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary<String, String> removeConfiguration(String pid) {
        Map<String, Dictionary<String, String>> map = this.configurations;
        synchronized (map) {
            return this.configurations.remove(pid);
        }
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public List<OSGiModule> getModules() {
        return Collections.unmodifiableList(this.modules);
    }

    void addModule(OSGiModule module) {
        this.modules.add(module);
    }

    public Activation getActivationPolicy() {
        return this.activationPolicy;
    }

    void setActivation(Activation activation) {
        this.activationPolicy = activation;
    }

    boolean isEmpty() {
        return this.properties.isEmpty() && this.modules.isEmpty() && this.configurations.isEmpty();
    }

    public static class OSGiModule
    implements Serializable {
        private static final long serialVersionUID = -2280880859263752474L;
        private final ModuleIdentifier identifier;
        private final boolean start;

        OSGiModule(ModuleIdentifier identifier, boolean start) {
            this.identifier = identifier;
            this.start = start;
        }

        public ModuleIdentifier getIdentifier() {
            return this.identifier;
        }

        public boolean isStart() {
            return this.start;
        }
    }

    public static enum Activation {
        EAGER,
        LAZY;

    }
}

