/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import org.jboss.as.osgi.deployment.DeploymentHolderService;
import org.jboss.as.osgi.deployment.ModuleRegistrationService;
import org.jboss.as.osgi.deployment.OSGiDeploymentService;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.BundleManagerService;
import org.jboss.as.osgi.service.FrameworkService;
import org.jboss.as.server.deployment.Services;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.AbstractUserBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.launch.Framework;

public class BundleContextService
implements Service<BundleContext> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"osgi", "context"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<Framework> injectedFramework = new InjectedValue();
    private BundleContext sysContext;

    public static void addService(ServiceTarget target, SubsystemState.Activation policy) {
        BundleContextService service = new BundleContextService();
        ServiceBuilder serviceBuilder = target.addService(SERVICE_NAME, (Service)service);
        serviceBuilder.addDependency(BundleManagerService.SERVICE_NAME, BundleManager.class, service.injectedBundleManager);
        serviceBuilder.addDependency(FrameworkService.SERVICE_NAME, Framework.class, service.injectedFramework);
        serviceBuilder.setInitialMode(policy == SubsystemState.Activation.LAZY ? ServiceController.Mode.ON_DEMAND : ServiceController.Mode.ACTIVE);
        serviceBuilder.install();
    }

    public static BundleContext getServiceValue(ServiceContainer container) {
        try {
            ServiceController controller = container.getRequiredService(SERVICE_NAME);
            return (BundleContext)controller.getValue();
        }
        catch (ServiceNotFoundException ex) {
            throw new IllegalStateException("Cannot obtain required service: " + SERVICE_NAME);
        }
    }

    public synchronized void start(final StartContext context) throws StartException {
        this.sysContext = ((Framework)this.injectedFramework.getValue()).getBundleContext();
        BundleListener bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 1) {
                    AbstractUserBundle userBundle;
                    try {
                        userBundle = AbstractUserBundle.assertBundleState((Bundle)event.getBundle());
                    }
                    catch (RuntimeException ex) {
                        return;
                    }
                    Deployment dep = userBundle.getDeployment();
                    String contextName = DeploymentHolderService.getContextName(dep);
                    ServiceContainer container = context.getController().getServiceContainer();
                    ServiceName osgiDeploymentService = OSGiDeploymentService.getServiceName(contextName);
                    ServiceName deploymentService = Services.deploymentUnitName((String)contextName);
                    if (container.getService(deploymentService) != null && container.getService(osgiDeploymentService) == null) {
                        ServiceName serviceName = ModuleRegistrationService.getServiceName(contextName);
                        try {
                            log.tracef("Register service: %s", (Object)serviceName);
                            ServiceTarget serviceTarget = container.subTarget();
                            ModuleRegistrationService.addService(serviceTarget, dep, contextName);
                        }
                        catch (ServiceRegistryException ex) {
                            throw new IllegalStateException("Cannot register service: " + serviceName, ex);
                        }
                    }
                }
            }
        };
        this.sysContext.addBundleListener(bundleListener);
    }

    public synchronized void stop(StopContext context) {
        this.sysContext = null;
    }

    public BundleContext getValue() throws IllegalStateException {
        return this.sysContext;
    }
}

