/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.osgi.deployment.DeploymentHolderService;
import org.jboss.as.osgi.deployment.OSGiDeploymentService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.SystemDeployerService;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.plugin.AbstractDeployerServicePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class DeployerServicePluginIntegration
extends AbstractDeployerServicePlugin {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    private ServerDeploymentManager deploymentManager;
    private ServiceContainer serviceContainer;

    public DeployerServicePluginIntegration(BundleManager bundleManager, ServiceContainer serviceContainer, ServerDeploymentManager deploymentManager) {
        super(bundleManager);
        this.deploymentManager = deploymentManager;
        this.serviceContainer = serviceContainer;
    }

    protected DeployerService getDeployerService(BundleContext context) {
        return new SystemDeployerService(context){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Bundle installBundle(Deployment dep) throws BundleException {
                log.tracef("Install deployment: %s", (Object)dep);
                Bundle bundle = null;
                String contextName = DeploymentHolderService.getContextName(dep);
                InitialDeploymentPlanBuilder builder = DeployerServicePluginIntegration.this.deploymentManager.newDeploymentPlan();
                try {
                    ServiceTarget serviceTarget = DeployerServicePluginIntegration.this.serviceContainer.subTarget();
                    DeploymentHolderService.addService(serviceTarget, contextName, dep);
                    OSGiDeploymentLatchService.addService(serviceTarget, contextName);
                    InputStream inputStream = dep.getRoot().openStream();
                    builder = builder.add(contextName, inputStream).andDeploy();
                    DeploymentPlan plan = builder.build();
                    DeploymentAction deployAction = builder.getLastAction();
                    DeployerServicePluginIntegration.this.executeDeploymentPlan(plan, deployAction);
                    final CountDownLatch latch = new CountDownLatch(1);
                    ServiceName serviceName = OSGiDeploymentLatchService.getServiceName(contextName);
                    ServiceController controller = DeployerServicePluginIntegration.this.serviceContainer.getService(serviceName);
                    controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                        public void listenerAdded(ServiceController<? extends Object> controller) {
                            if (controller.getState() == ServiceController.State.UP) {
                                this.serviceStarted(controller);
                            } else if (controller.getState() == ServiceController.State.START_FAILED) {
                                this.serviceFailed(controller, controller.getStartException());
                            }
                        }

                        public void serviceStarted(ServiceController<? extends Object> controller) {
                            log.tracef("Service started: %s", (Object)controller.getName());
                            controller.removeListener((ServiceListener)this);
                            latch.countDown();
                        }

                        public void serviceFailed(ServiceController<? extends Object> controller, StartException reason) {
                            log.tracef((Throwable)reason, "Service failed: %s", (Object)controller.getName());
                            controller.removeListener((ServiceListener)this);
                            latch.countDown();
                        }
                    });
                    try {
                        latch.await(10L, TimeUnit.SECONDS);
                        if (controller.getState() == ServiceController.State.START_FAILED) {
                            throw controller.getStartException();
                        }
                        if (controller.getState() != ServiceController.State.UP) {
                            throw new BundleException("OSGiDeploymentService not available: " + serviceName);
                        }
                        Deployment bundleDep = (Deployment)controller.getValue();
                        bundle = (Bundle)bundleDep.getAttachment(Bundle.class);
                    }
                    finally {
                        controller.setMode(ServiceController.Mode.REMOVE);
                    }
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (BundleException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new BundleException("Cannot deploy bundle: " + dep, (Throwable)ex);
                }
                finally {
                    DeploymentHolderService.removeService(DeployerServicePluginIntegration.this.serviceContainer, contextName);
                }
                if (bundle == null) {
                    throw new IllegalStateException("Cannot find bundle: " + contextName);
                }
                return bundle;
            }

            protected void uninstallBundle(Deployment dep, Bundle bundle) throws BundleException {
                try {
                    String contextName = DeploymentHolderService.getContextName(dep);
                    ServiceName serviceName = OSGiDeploymentService.getServiceName(contextName);
                    ServiceController controller = DeployerServicePluginIntegration.this.serviceContainer.getService(serviceName);
                    if (controller == null) {
                        DeployerServicePluginIntegration.this.getBundleManager().uninstallBundle(dep);
                        return;
                    }
                    final CountDownLatch latch = new CountDownLatch(1);
                    controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                        public void listenerAdded(ServiceController<? extends Object> controller) {
                            if (controller.getState() == ServiceController.State.REMOVED) {
                                this.serviceRemoved(controller);
                            } else if (controller.getState() == ServiceController.State.START_FAILED) {
                                this.serviceFailed(controller, controller.getStartException());
                            }
                        }

                        public void serviceRemoved(ServiceController<? extends Object> controller) {
                            log.tracef("Service removed: %s", (Object)controller.getName());
                            controller.removeListener((ServiceListener)this);
                            latch.countDown();
                        }

                        public void serviceFailed(ServiceController<? extends Object> controller, StartException reason) {
                            log.tracef((Throwable)reason, "Service failed: %s", (Object)controller.getName());
                            controller.removeListener((ServiceListener)this);
                            latch.countDown();
                        }
                    });
                    InitialDeploymentPlanBuilder builder = DeployerServicePluginIntegration.this.deploymentManager.newDeploymentPlan();
                    builder = builder.undeploy(contextName).remove(contextName);
                    DeploymentPlan plan = builder.build();
                    DeploymentAction removeAction = builder.getLastAction();
                    DeployerServicePluginIntegration.this.executeDeploymentPlan(plan, removeAction);
                    latch.await(10L, TimeUnit.SECONDS);
                    if (controller.getState() == ServiceController.State.START_FAILED) {
                        throw controller.getStartException();
                    }
                    if (controller.getState() != ServiceController.State.REMOVED) {
                        throw new BundleException("OSGiDeploymentService not removed: " + serviceName);
                    }
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (BundleException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new BundleException("Cannot undeploy bundle: " + dep, (Throwable)ex);
                }
            }
        };
    }

    private String executeDeploymentPlan(DeploymentPlan plan, DeploymentAction action) throws Exception {
        Exception deploymentException;
        Future future = this.deploymentManager.execute(plan);
        ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)future.get();
        ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(action.getId());
        if (actionResult != null && (deploymentException = (Exception)actionResult.getDeploymentException()) != null) {
            throw deploymentException;
        }
        return action.getDeploymentUnitUniqueName();
    }

    static class OSGiDeploymentLatchService
    extends AbstractService<Deployment> {
        private InjectedValue<Deployment> injectedDeployment = new InjectedValue();

        OSGiDeploymentLatchService() {
        }

        static void addService(ServiceTarget serviceTarget, String contextName) {
            OSGiDeploymentLatchService service = new OSGiDeploymentLatchService();
            ServiceBuilder serviceBuilder = serviceTarget.addService(OSGiDeploymentLatchService.getServiceName(contextName), (Service)service);
            ServiceName serviceName = OSGiDeploymentService.getServiceName(contextName);
            serviceBuilder.addDependency(serviceName, Deployment.class, service.injectedDeployment);
            serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
            serviceBuilder.install();
        }

        static ServiceName getServiceName(String contextName) {
            return OSGiDeploymentService.SERVICE_NAME_BASE.append(new String[]{"latch", contextName});
        }

        public Deployment getValue() throws IllegalStateException {
            return (Deployment)this.injectedDeployment.getValue();
        }
    }
}

