/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.osgi.deployment.BundleInfoAttachment;
import org.jboss.as.osgi.deployment.BundleInstallService;
import org.jboss.as.osgi.deployment.DeploymentHolderService;
import org.jboss.as.osgi.deployment.OSGiDeploymentAttachment;
import org.jboss.as.osgi.deployment.OSGiMetaDataAttachment;
import org.jboss.as.osgi.deployment.XModuleAttachment;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Version;

public class BundleInstallProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ServiceRegistry serviceRegistry;
        ServiceController<Deployment> controller;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String contextName = deploymentUnit.getName();
        Deployment deployment = OSGiDeploymentAttachment.getDeployment(deploymentUnit);
        if (deployment == null && (controller = DeploymentHolderService.getDeployment(serviceRegistry = phaseContext.getServiceRegistry(), contextName)) != null) {
            deployment = (Deployment)controller.getValue();
            controller.setMode(ServiceController.Mode.REMOVE);
        }
        BundleInfo info = BundleInfoAttachment.getBundleInfo(deploymentUnit);
        if (deployment == null && info != null) {
            deployment = DeploymentFactory.createDeployment((BundleInfo)info);
            deployment.addAttachment(BundleInfo.class, (Object)info);
            deployment.setAutoStart(true);
            OSGiDeploymentAttachment.attachDeployment(deploymentUnit, deployment);
        }
        OSGiMetaData metadata = OSGiMetaDataAttachment.getOSGiMetaData(deploymentUnit);
        if (deployment == null && metadata != null) {
            String symbolicName = metadata.getBundleSymbolicName();
            Version version = metadata.getBundleVersion();
            org.jboss.vfs.VirtualFile virtualFile = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
            deployment = DeploymentFactory.createDeployment((VirtualFile)AbstractVFS.adapt((Object)virtualFile), (String)contextName, (String)symbolicName, (Version)version);
            deployment.setAutoStart(true);
            deployment.addAttachment(OSGiMetaData.class, (Object)metadata);
            OSGiDeploymentAttachment.attachDeployment(deploymentUnit, deployment);
        }
        XModule resModule = XModuleAttachment.getXModuleAttachment(deploymentUnit);
        if (deployment == null && resModule != null) {
            String symbolicName = resModule.getName();
            Version version = resModule.getVersion();
            org.jboss.vfs.VirtualFile virtualFile = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
            deployment = DeploymentFactory.createDeployment((VirtualFile)AbstractVFS.adapt((Object)virtualFile), (String)contextName, (String)symbolicName, (Version)version);
            deployment.setAutoStart(true);
            deployment.addAttachment(XModule.class, (Object)resModule);
            OSGiDeploymentAttachment.attachDeployment(deploymentUnit, deployment);
        }
        if (deployment != null) {
            BundleInstallService.addService(phaseContext, deployment);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        BundleInstallService.removeService(deploymentUnit);
    }
}

