/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum Namespace {
    UNKNOWN(null),
    OSGI_1_0("urn:jboss:domain:osgi:1.0");

    public static final Namespace CURRENT;
    private final String name;
    public static final EnumSet<Namespace> STANDARD_NAMESPACES;
    private static final Map<String, Namespace> MAP;

    private Namespace(String name) {
        this.name = name;
    }

    public String getUriString() {
        return this.name;
    }

    public static Namespace forUri(String uri) {
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        CURRENT = OSGI_1_0;
        STANDARD_NAMESPACES = EnumSet.complementOf(EnumSet.of(UNKNOWN));
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

