/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.osgi.parser.OSGiSubsystemProviders;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.ModuleIdentifier;

public class OSGiModuleAdd
implements OperationStepHandler,
DescriptionProvider {
    static final OSGiModuleAdd INSTANCE = new OSGiModuleAdd();

    private OSGiModuleAdd() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Integer startLevel;
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        ModelNode slNode = null;
        if (operation.has("start")) {
            slNode = operation.get("start");
            model.get("start").set(slNode);
        }
        Integer n = startLevel = slNode != null ? Integer.valueOf(slNode.asInt()) : null;
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    String identifier = operation.get("address").asObject().get("module").asString();
                    SubsystemState.OSGiModule module = new SubsystemState.OSGiModule(ModuleIdentifier.fromString((String)identifier), startLevel);
                    SubsystemState stateService = (SubsystemState)context.getServiceRegistry(true).getRequiredService(SubsystemState.SERVICE_NAME).getValue();
                    stateService.addModule(module);
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        stateService.removeModule(identifier);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        ResourceBundle resourceBundle = OSGiSubsystemProviders.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(resourceBundle.getString("module.add"));
        OSGiModuleAdd.addModelProperties(resourceBundle, node, "request-properties");
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static void addModelProperties(ResourceBundle bundle, ModelNode node, String propType) {
        node.get(new String[]{propType, "start", "description"}).set(bundle.getString("module.startlevel"));
        node.get(new String[]{propType, "start", "type"}).set(ModelType.INT);
        node.get(new String[]{propType, "start", "required"}).set(false);
    }

    static ModelNode getAddOperation(ModelNode address, ModelNode existing) {
        ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)address);
        if (existing.hasDefined("start")) {
            op.get("start").set(existing.get("start"));
        }
        return op;
    }
}

