/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.osgi.parser.OSGiCasConfigAdd;
import org.jboss.as.osgi.parser.OSGiModuleAdd;
import org.jboss.as.osgi.parser.OSGiPropertyAdd;
import org.jboss.as.osgi.parser.OSGiSubsystemAdd;
import org.jboss.dmr.ModelNode;

class OSGiSubsystemProviders {
    static final String RESOURCE_NAME = OSGiSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return OSGiSubsystemProviders.getRootResource(locale);
        }
    };
    static final DescriptionProvider OSGI_CONFIGURATION_RESOURCE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return OSGiSubsystemProviders.getCasConfiguration(locale);
        }
    };
    static final DescriptionProvider OSGI_PROPERTY_RESOURCE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return OSGiSubsystemProviders.getProperty(locale);
        }
    };
    static final DescriptionProvider OSGI_MODULE_RESOURCE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return OSGiSubsystemProviders.getModule(locale);
        }
    };

    OSGiSubsystemProviders() {
    }

    static ModelNode getRootResource(Locale locale) {
        ResourceBundle bundle = OSGiSubsystemProviders.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("osgi"));
        OSGiSubsystemAdd.addModelProperties(bundle, node, "attributes");
        node.get(new String[]{"children", "configuration"}).set(OSGiSubsystemProviders.getCasConfiguration(locale));
        node.get(new String[]{"children", "property"}).set(OSGiSubsystemProviders.getProperty(locale));
        node.get(new String[]{"children", "module"}).set(OSGiSubsystemProviders.getModule(locale));
        return node;
    }

    private static ModelNode getCasConfiguration(Locale locale) {
        ResourceBundle bundle = OSGiSubsystemProviders.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("config"));
        OSGiCasConfigAdd.addModelProperties(bundle, node, "attributes");
        return node;
    }

    private static ModelNode getProperty(Locale locale) {
        ResourceBundle bundle = OSGiSubsystemProviders.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("property"));
        OSGiPropertyAdd.addModelProperties(bundle, node, "attributes");
        return node;
    }

    private static ModelNode getModule(Locale locale) {
        ResourceBundle bundle = OSGiSubsystemProviders.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("module"));
        OSGiModuleAdd.addModelProperties(bundle, node, "attributes");
        return node;
    }

    static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

