/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.AutoInstallProvider;
import org.jboss.osgi.framework.BundleManagerService;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.spi.util.BundleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.startlevel.StartLevel;

class AutoInstallIntegration
extends AbstractService<AutoInstallProvider>
implements AutoInstallProvider,
Observer {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    final InjectedValue<BundleManagerService> injectedBundleManager = new InjectedValue();
    private final InjectedValue<ServerEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<Bundle> injectedSystemBundle = new InjectedValue();
    private final InjectedValue<StartLevel> injectedStartLevel = new InjectedValue();
    final InjectedValue<SubsystemState> injectedSubsystemState = new InjectedValue();
    private File bundlesDir;
    ServiceController<?> serviceController;
    private ServiceTarget serviceTarget;
    private final AtomicLong updateServiceIdCounter = new AtomicLong();

    static ServiceController<?> addService(ServiceTarget target) {
        AutoInstallIntegration service = new AutoInstallIntegration();
        ServiceBuilder builder = target.addService(Services.AUTOINSTALL_PROVIDER, (Service)service);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedEnvironment);
        builder.addDependency(SubsystemState.SERVICE_NAME, SubsystemState.class, service.injectedSubsystemState);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerService.class, service.injectedBundleManager);
        builder.addDependency(Services.SYSTEM_BUNDLE, Bundle.class, service.injectedSystemBundle);
        builder.addDependency(Services.START_LEVEL, StartLevel.class, service.injectedStartLevel);
        builder.addDependency(Services.FRAMEWORK_INIT);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        return builder.install();
    }

    AutoInstallIntegration() {
    }

    public synchronized void start(StartContext context) throws StartException {
        this.serviceController = context.getController();
        log.debugf("Starting: %s in mode %s", (Object)this.serviceController.getName(), (Object)this.serviceController.getMode());
        final LinkedHashMap<ServiceName, SubsystemState.OSGiModule> pendingServices = new LinkedHashMap<ServiceName, SubsystemState.OSGiModule>();
        try {
            BundleManagerService bundleManager = (BundleManagerService)this.injectedBundleManager.getValue();
            final ServiceContainer serviceContainer = this.serviceController.getServiceContainer();
            this.serviceTarget = context.getChildTarget();
            File modulesDir = ((ServerEnvironment)this.injectedEnvironment.getValue()).getModulesDir();
            this.bundlesDir = new File(modulesDir.getPath() + "/../bundles").getCanonicalFile();
            if (!this.bundlesDir.isDirectory()) {
                throw new IllegalStateException("Cannot find bundles directory: " + this.bundlesDir);
            }
            ((SubsystemState)this.injectedSubsystemState.getValue()).addObserver(this);
            for (SubsystemState.OSGiModule moduleMetaData : ((SubsystemState)this.injectedSubsystemState.getValue()).getModules()) {
                ServiceName serviceName = this.installModule(bundleManager, moduleMetaData);
                pendingServices.put(serviceName, moduleMetaData);
            }
            ServiceName servicesInstalled = Services.AUTOINSTALL_PROVIDER.append(new String[]{"INSTALLED"});
            ServiceBuilder builder = this.serviceTarget.addService(servicesInstalled, (Service)new AbstractService<Void>(){

                public void start(StartContext context) throws StartException {
                    log.debugf("Auto bundles installed", new Object[0]);
                }
            });
            builder.addDependencies(pendingServices.keySet());
            builder.install();
            builder = this.serviceTarget.addService(Services.AUTOINSTALL_PROVIDER_COMPLETE, (Service)new AbstractService<Void>(){

                public void start(StartContext context) throws StartException {
                    for (ServiceName serviceName : pendingServices.keySet()) {
                        SubsystemState.OSGiModule moduleMetaData = (SubsystemState.OSGiModule)pendingServices.get(serviceName);
                        AutoInstallIntegration.this.startBundle(serviceContainer, serviceName, moduleMetaData);
                    }
                    log.debugf("Auto bundles bundles started", new Object[0]);
                }
            });
            builder.addDependencies(new ServiceName[]{servicesInstalled});
            builder.install();
        }
        catch (Exception ex) {
            throw new StartException("Failed to create auto install list", (Throwable)ex);
        }
    }

    ServiceName installModule(BundleManagerService bundleManager, SubsystemState.OSGiModule moduleMetaData) throws IOException, BundleException, ModuleLoadException {
        ModuleIdentifier identifier = moduleMetaData.getIdentifier();
        File bundleFile = this.getRepositoryEntry(this.bundlesDir, identifier);
        if (bundleFile != null) {
            URL url = bundleFile.toURI().toURL();
            BundleInfo info = BundleInfo.createBundleInfo((URL)url);
            Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
            Integer startLevel = moduleMetaData.getStartLevel();
            if (startLevel != null) {
                dep.setStartLevel(Integer.valueOf(startLevel));
            }
            return bundleManager.installBundle(this.serviceTarget, dep);
        }
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        Module module = moduleLoader.loadModule(identifier);
        OSGiMetaData metadata = this.getModuleMetadata(module);
        return bundleManager.registerModule(this.serviceTarget, module, metadata);
    }

    void startBundle(ServiceContainer serviceContainer, ServiceName serviceName, SubsystemState.OSGiModule moduleMetaData) {
        if (moduleMetaData.getStartLevel() != null) {
            ServiceController controller = serviceContainer.getRequiredService(serviceName);
            Bundle bundle = (Bundle)controller.getValue();
            StartLevel startLevel = (StartLevel)this.injectedStartLevel.getValue();
            startLevel.setBundleStartLevel(bundle, moduleMetaData.getStartLevel().intValue());
            try {
                bundle.start();
            }
            catch (BundleException ex) {
                log.errorf((Throwable)ex, "Cannot start bundle: %s", (Object)bundle);
            }
        }
    }

    public synchronized AutoInstallIntegration getValue() throws IllegalStateException {
        return this;
    }

    private File getRepositoryEntry(File rootDir, ModuleIdentifier identifier) throws IOException {
        String identifierPath = identifier.getName().replace('.', '/') + "/" + identifier.getSlot();
        File entryDir = new File(rootDir + "/" + identifierPath);
        if (!entryDir.isDirectory()) {
            log.debugf("Cannot obtain directory: %s", (Object)entryDir);
            return null;
        }
        String[] files = entryDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files.length == 0) {
            log.debugf("Cannot find jar in: %s", (Object)entryDir);
            return null;
        }
        if (files.length > 1) {
            log.debugf("Multiple jars in: %s", (Object)entryDir);
            return null;
        }
        File entryFile = new File(entryDir + "/" + files[0]);
        if (!entryFile.exists()) {
            log.debugf("File does not exist: %s", (Object)entryFile);
            return null;
        }
        return entryFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OSGiMetaData getModuleMetadata(Module module) throws IOException {
        File modulesDir = ((ServerEnvironment)this.injectedEnvironment.getValue()).getModulesDir();
        ModuleIdentifier identifier = module.getIdentifier();
        String identifierPath = identifier.getName().replace('.', '/') + "/" + identifier.getSlot();
        File entryFile = new File(modulesDir + "/" + identifierPath + "/jbosgi-xservice.properties");
        if (!entryFile.exists()) {
            log.debugf("Cannot obtain OSGi metadata file: %s", (Object)entryFile);
            return null;
        }
        FileInputStream input = new FileInputStream(entryFile);
        try {
            OSGiMetaData oSGiMetaData = OSGiMetaDataBuilder.load((InputStream)input);
            return oSGiMetaData;
        }
        finally {
            input.close();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!(arg instanceof SubsystemState.ChangeEvent)) {
            return;
        }
        SubsystemState.ChangeEvent event = (SubsystemState.ChangeEvent)arg;
        if (event.getType() != SubsystemState.ChangeType.MODULE) {
            return;
        }
        if (!event.isRemoved()) {
            try {
                for (final SubsystemState.OSGiModule module : ((SubsystemState)this.injectedSubsystemState.getValue()).getModules()) {
                    if (!module.getIdentifier().toString().equals(event.getId())) continue;
                    final ServiceName serviceName = this.installModule((BundleManagerService)this.injectedBundleManager.getValue(), module);
                    ServiceBuilder builder = this.serviceController.getServiceContainer().addService(ServiceName.of((ServiceName)Services.AUTOINSTALL_PROVIDER, (String[])new String[]{"ModuleUpdater", "" + this.updateServiceIdCounter.incrementAndGet()}), (Service)new AbstractService<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void start(StartContext context) throws StartException {
                            try {
                                AutoInstallIntegration.this.startBundle(AutoInstallIntegration.this.serviceController.getServiceContainer(), serviceName, module);
                            }
                            finally {
                                context.getController().setMode(ServiceController.Mode.REMOVE);
                            }
                        }
                    });
                    builder.addDependency(serviceName);
                    builder.install();
                    return;
                }
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Problem adding module: %s", (Object)event.getId());
                return;
            }
            log.errorf("Cannot add module as it was not found: %s", (Object)event.getId());
        }
    }
}

