/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.List;
import javax.annotation.Resource;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Type;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.osgi.framework.Services;
import org.osgi.framework.BundleContext;

public class BundleContextJndiBindingProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDesc = (EEModuleDescription)depUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDesc == null) {
            return;
        }
        CompositeIndex compositeIndex = (CompositeIndex)depUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            OSGiLogger.ROOT_LOGGER.cannotFindAnnotationIndex(depUnit);
            return;
        }
        boolean hasBundleContextResource = false;
        DotName resourceDotName = DotName.createSimple((String)Resource.class.getName());
        DotName targetDotName = DotName.createSimple((String)BundleContext.class.getName());
        List anList = compositeIndex.getAnnotations(resourceDotName);
        for (AnnotationInstance an : anList) {
            FieldInfo fieldInfo;
            Type targetType;
            AnnotationTarget anTarget = an.target();
            if (!(anTarget instanceof FieldInfo) || !(targetType = (fieldInfo = (FieldInfo)anTarget).type()).name().equals((Object)targetDotName)) continue;
            hasBundleContextResource = true;
            break;
        }
        if (!hasBundleContextResource) {
            return;
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)depUnit)) {
            ServiceName serviceName = ContextNames.contextServiceNameOfModule((String)moduleDesc.getApplicationName(), (String)moduleDesc.getModuleName());
            this.bindServices(depUnit, serviceTarget, moduleDesc, moduleDesc.getModuleName(), serviceName);
        }
        for (ComponentDescription comp : moduleDesc.getComponentDescriptions()) {
            if (comp.getNamingMode() != ComponentNamingMode.CREATE) continue;
            ServiceName serviceName = ContextNames.contextServiceNameOfComponent((String)moduleDesc.getApplicationName(), (String)moduleDesc.getModuleName(), (String)comp.getComponentName());
            this.bindServices(depUnit, serviceTarget, moduleDesc, comp.getComponentName(), serviceName);
        }
    }

    private void bindServices(DeploymentUnit depUnit, ServiceTarget serviceTarget, EEModuleDescription description, String componentName, ServiceName contextServiceName) {
        ServiceName serviceName = contextServiceName.append(new String[]{"BundleContext"});
        BinderService bindingService = new BinderService("BundleContext");
        ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)bindingService);
        builder.addDependency(Services.SYSTEM_CONTEXT, BundleContext.class, (Injector)new ManagedReferenceInjector(bindingService.getManagedObjectInjector()));
        builder.addDependency(contextServiceName, ServiceBasedNamingStore.class, bindingService.getNamingStoreInjector());
        builder.addDependency(Services.FRAMEWORK_ACTIVATOR);
        builder.install();
    }

    public void undeploy(DeploymentUnit context) {
    }
}

