/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.osgi.parser.OSGiSubsystemProviders;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class OSGiCasConfigAdd
implements OperationStepHandler,
DescriptionProvider {
    static final OSGiCasConfigAdd INSTANCE = new OSGiCasConfigAdd();

    private OSGiCasConfigAdd() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        final ModelNode entries = operation.get("entries");
        model.get("entries").set(entries);
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode identifier = operation.get("address").asObject().get("configuration");
                    String pid = identifier.asString();
                    Hashtable<String, String> dictionary = new Hashtable<String, String>();
                    for (String key : entries.keys()) {
                        ((Dictionary)dictionary).put(key, entries.get(key).asString());
                    }
                    SubsystemState stateService = (SubsystemState)context.getServiceRegistry(true).getRequiredService(SubsystemState.SERVICE_NAME).getValue();
                    stateService.putConfiguration(pid, dictionary);
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        stateService.removeConfiguration(pid);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        ResourceBundle resourceBundle = OSGiSubsystemProviders.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(resourceBundle.getString("config.add"));
        OSGiCasConfigAdd.addModelProperties(resourceBundle, node, "request-properties");
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static void addModelProperties(ResourceBundle bundle2, ModelNode node, String propType) {
        node.get(new String[]{propType, "entries", "description"}).set(bundle2.getString("config.entries"));
        node.get(new String[]{propType, "entries", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{propType, "entries", "required"}).set(true);
    }

    static ModelNode getAddOperation(ModelNode address, ModelNode existing) {
        ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)address);
        if (existing.hasDefined("entries")) {
            op.get("entries").set(existing.get("entries"));
        }
        return op;
    }
}

