/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.osgi.parser.ActivationWriteHandler;
import org.jboss.as.osgi.parser.Namespace;
import org.jboss.as.osgi.parser.OSGiCasConfigAdd;
import org.jboss.as.osgi.parser.OSGiCasConfigRemove;
import org.jboss.as.osgi.parser.OSGiModuleAdd;
import org.jboss.as.osgi.parser.OSGiModuleRemove;
import org.jboss.as.osgi.parser.OSGiPropertyAdd;
import org.jboss.as.osgi.parser.OSGiPropertyRemove;
import org.jboss.as.osgi.parser.OSGiSubsystemAdd;
import org.jboss.as.osgi.parser.OSGiSubsystemDescribeHandler;
import org.jboss.as.osgi.parser.OSGiSubsystemParser;
import org.jboss.as.osgi.parser.OSGiSubsystemProviders;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class OSGiExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "osgi";
    private final OSGiSubsystemParser parser = new OSGiSubsystemParser();

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)this.parser);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(OSGiSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)OSGiSubsystemAdd.INSTANCE, (DescriptionProvider)OSGiSubsystemAdd.INSTANCE, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)OSGiSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)OSGiSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        registration.registerReadWriteAttribute("activation", null, (OperationStepHandler)new ActivationWriteHandler(), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration casConfigs = registration.registerSubModel(PathElement.pathElement((String)"configuration"), OSGiSubsystemProviders.OSGI_CONFIGURATION_RESOURCE);
        casConfigs.registerOperationHandler("add", (OperationStepHandler)OSGiCasConfigAdd.INSTANCE, (DescriptionProvider)OSGiCasConfigAdd.INSTANCE, false);
        casConfigs.registerOperationHandler("remove", (OperationStepHandler)OSGiCasConfigRemove.INSTANCE, (DescriptionProvider)OSGiCasConfigRemove.INSTANCE, false);
        ManagementResourceRegistration properties = registration.registerSubModel(PathElement.pathElement((String)"property"), OSGiSubsystemProviders.OSGI_PROPERTY_RESOURCE);
        properties.registerOperationHandler("add", (OperationStepHandler)OSGiPropertyAdd.INSTANCE, (DescriptionProvider)OSGiPropertyAdd.INSTANCE, false);
        properties.registerOperationHandler("remove", (OperationStepHandler)OSGiPropertyRemove.INSTANCE, (DescriptionProvider)OSGiPropertyRemove.INSTANCE, false);
        ManagementResourceRegistration modules = registration.registerSubModel(PathElement.pathElement((String)"module"), OSGiSubsystemProviders.OSGI_MODULE_RESOURCE);
        modules.registerOperationHandler("add", (OperationStepHandler)OSGiModuleAdd.INSTANCE, (DescriptionProvider)OSGiModuleAdd.INSTANCE, false);
        modules.registerOperationHandler("remove", (OperationStepHandler)OSGiModuleRemove.INSTANCE, (DescriptionProvider)OSGiModuleRemove.INSTANCE, false);
        subsystem.registerXMLElementWriter((XMLElementWriter)this.parser);
    }
}

