/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.osgi.parser.OSGiCasConfigAdd;
import org.jboss.as.osgi.parser.OSGiModuleAdd;
import org.jboss.as.osgi.parser.OSGiPropertyAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class OSGiSubsystemDescribeHandler
implements OperationStepHandler,
DescriptionProvider {
    static final OSGiSubsystemDescribeHandler INSTANCE = new OSGiSubsystemDescribeHandler();

    OSGiSubsystemDescribeHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode address;
        ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(rootAddress.toModelNode());
        if (model.has("activation")) {
            subsystem.get("activation").set(model.get("activation"));
        }
        ModelNode result = context.getResult();
        result.add(subsystem);
        if (model.has("configuration")) {
            for (Property conf : model.get("configuration").asPropertyList()) {
                address = rootAddress.toModelNode();
                address.add("configuration", conf.getName());
                result.add(OSGiCasConfigAdd.getAddOperation(address, conf.getValue()));
            }
        }
        if (model.has("property")) {
            for (Property prop : model.get("property").asPropertyList()) {
                address = rootAddress.toModelNode();
                address.add("property", prop.getName());
                result.add(OSGiPropertyAdd.getAddOperation(address, prop.getValue()));
            }
        }
        if (model.has("module")) {
            for (Property prop : model.get("module").asPropertyList()) {
                address = rootAddress.toModelNode();
                address.add("module", prop.getName());
                result.add(OSGiModuleAdd.getAddOperation(address, prop.getValue()));
            }
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
    }
}

