/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.parser.Attribute;
import org.jboss.as.osgi.parser.Element;
import org.jboss.as.osgi.parser.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class OSGiSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    OSGiSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "osgi");
        address.protect();
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        this.parseActivationAttribute(reader, operation);
        operations.add(operation);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OSGI_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONFIGURATION: {
                            ModelNode configurations = this.parseConfigurationElement(reader, address);
                            if (configurations == null) continue block8;
                            operations.add(configurations);
                            continue block8;
                        }
                        case PROPERTIES: {
                            operations.addAll(this.parsePropertiesElement(reader, address, operations));
                            continue block8;
                        }
                        case MODULES: {
                            operations.addAll(this.parseModulesElement(reader, address));
                            continue block8;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseActivationAttribute(XMLExtendedStreamReader reader, ModelNode addOperation) throws XMLStreamException {
        switch (Namespace.forUri(reader.getNamespaceURI())) {
            case OSGI_1_0: {
                int count = reader.getAttributeCount();
                block6: for (int i = 0; i < count; ++i) {
                    ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                    String attrValue = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case ACTIVATION: {
                            addOperation.get("activation").set(attrValue);
                            continue block6;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                    }
                }
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    ModelNode parseConfigurationElement(XMLExtendedStreamReader reader, ModelNode address) throws XMLStreamException {
        String pid = null;
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attrValue = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PID: {
                    pid = attrValue;
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (pid == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PID));
        }
        ModelNode rootNode = new ModelNode();
        rootNode.get("operation").set("add");
        rootNode.get("address").set(address).add("configuration", pid);
        ModelNode configuration = rootNode.get("entries");
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OSGI_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (element == Element.PROPERTY) {
                        String name = null;
                        count = reader.getAttributeCount();
                        block11: for (int i = 0; i < count; ++i) {
                            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                            String attrValue = reader.getAttributeValue(i);
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case NAME: {
                                    name = attrValue;
                                    if (!configuration.has(name)) continue block11;
                                    throw new XMLStreamException(OSGiMessages.MESSAGES.propertyAlreadyExists(name), reader.getLocation());
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        if (name == null) {
                            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
                        }
                        String value = reader.getElementText().trim();
                        configuration.get(name).set(value);
                        continue block10;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return rootNode;
    }

    List<ModelNode> parsePropertiesElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operations) throws XMLStreamException {
        ArrayList<ModelNode> nodes = new ArrayList<ModelNode>();
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OSGI_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (element == Element.PROPERTY) {
                        String name = null;
                        String value = null;
                        int count = reader.getAttributeCount();
                        block7: for (int i = 0; i < count; ++i) {
                            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                            String attrValue = reader.getAttributeValue(i);
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case NAME: {
                                    name = attrValue;
                                    continue block7;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        if (name == null) {
                            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
                        }
                        value = reader.getElementText().trim();
                        ModelNode propNode = new ModelNode();
                        propNode.get("operation").set("add");
                        propNode.get("address").set(address).add("property", name);
                        propNode.get("value").set(value);
                        nodes.add(propNode);
                        continue block6;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return nodes;
    }

    List<ModelNode> parseModulesElement(XMLExtendedStreamReader reader, ModelNode address) throws XMLStreamException {
        ArrayList<ModelNode> nodes = new ArrayList<ModelNode>();
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OSGI_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (element == Element.MODULE) {
                        String identifier = null;
                        String start = null;
                        int count = reader.getAttributeCount();
                        block8: for (int i = 0; i < count; ++i) {
                            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case IDENTIFIER: {
                                    identifier = reader.getAttributeValue(i);
                                    continue block8;
                                }
                                case STARTLEVEL: {
                                    start = reader.getAttributeValue(i);
                                    continue block8;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        if (identifier == null) {
                            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.IDENTIFIER));
                        }
                        ModelNode moduleNode = new ModelNode();
                        moduleNode.get("operation").set("add");
                        moduleNode.get("address").set(address).add("module", identifier);
                        if (start != null) {
                            moduleNode.get("start").set(start);
                        }
                        nodes.add(moduleNode);
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                        continue block7;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return nodes;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        if (this.has(node, "activation")) {
            this.writeAttribute(writer, Attribute.ACTIVATION, node.get("activation"));
        }
        if (this.has(node, "configuration")) {
            ModelNode configuration = node.get("configuration");
            for (String pid : new TreeSet(configuration.keys())) {
                writer.writeStartElement(Element.CONFIGURATION.getLocalName());
                writer.writeAttribute(Attribute.PID.getLocalName(), pid);
                ModelNode properties = configuration.get(pid).get("entries");
                for (String propKey : properties.keys()) {
                    String value = properties.get(propKey).asString();
                    writer.writeStartElement(Element.PROPERTY.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), propKey);
                    writer.writeCharacters(value);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
        if (this.has(node, "property")) {
            writer.writeStartElement(Element.PROPERTIES.getLocalName());
            ModelNode properties = node.get("property");
            for (String key : new TreeSet(properties.keys())) {
                String val = properties.get(key).get("value").asString();
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), key);
                writer.writeCharacters(val);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.has(node, "module")) {
            writer.writeStartElement(Element.MODULES.getLocalName());
            ModelNode modules = node.get("module");
            for (String key : modules.keys()) {
                ModelNode moduleNode = modules.get(key);
                writer.writeEmptyElement(Element.MODULE.getLocalName());
                writer.writeAttribute(Attribute.IDENTIFIER.getLocalName(), key);
                if (!moduleNode.has("start")) continue;
                this.writeAttribute(writer, Attribute.STARTLEVEL, moduleNode.require("start"));
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private boolean has(ModelNode node, String name) {
        if (node.has(name) && node.get(name).isDefined()) {
            ModelNode n = node.get(name);
            switch (n.getType()) {
                case LIST: 
                case OBJECT: {
                    return n.asList().size() > 0;
                }
            }
            return true;
        }
        return false;
    }

    private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
        writer.writeAttribute(attr.getLocalName(), value.asString());
    }
}

