/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.osgi.parser.Namespace;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class OSGiSubsystemProviders {
    static final String RESOURCE_NAME = OSGiSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode subsystem = new ModelNode();
            ResourceBundle resbundle = OSGiSubsystemProviders.getResourceBundle(locale);
            subsystem.get("description").set(resbundle.getString("subsystem"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.CURRENT.getUriString());
            subsystem.get(new String[]{"attributes", "activation", "description"}).set(resbundle.getString("subsystem.activation"));
            subsystem.get(new String[]{"attributes", "activation", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "activation", "default"}).set(SubsystemState.DEFAULT_ACTIVATION.toString());
            subsystem.get(new String[]{"attributes", "activation", "access-type"}).set(AttributeAccess.AccessType.READ_WRITE.toString());
            subsystem.get(new String[]{"attributes", "activation", "restart-required"}).set(AttributeAccess.Flag.RESTART_JVM.toString());
            subsystem.get(new String[]{"attributes", "startlevel", "description"}).set(resbundle.getString("subsystem.startlevel"));
            subsystem.get(new String[]{"attributes", "startlevel", "type"}).set(ModelType.INT);
            subsystem.get(new String[]{"attributes", "startlevel", "access-type"}).set(AttributeAccess.AccessType.READ_WRITE.toString());
            subsystem.get(new String[]{"attributes", "startlevel", "restart-required"}).set(AttributeAccess.Flag.RESTART_NONE.toString());
            subsystem.get(new String[]{"attributes", "startlevel", "storage"}).set(AttributeAccess.Flag.STORAGE_RUNTIME.toString());
            subsystem.get(new String[]{"children", "configuration", "description"}).set(resbundle.getString("configuration"));
            subsystem.get(new String[]{"children", "property", "description"}).set(resbundle.getString("framework.property"));
            subsystem.get(new String[]{"children", "capability", "description"}).set(resbundle.getString("capability"));
            subsystem.get(new String[]{"children", "bundle", "description"}).set(resbundle.getString("bundle"));
            return subsystem;
        }
    };
    static final DescriptionProvider CONFIGURATION_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            ResourceBundle resbundle = OSGiSubsystemProviders.getResourceBundle(locale);
            node.get("description").set(resbundle.getString("configuration"));
            node.get(new String[]{"attributes", "entries", "description"}).set(resbundle.getString("configuration.entries"));
            node.get(new String[]{"attributes", "entries", "required"}).set(true);
            node.get(new String[]{"attributes", "entries", "type"}).set(ModelType.LIST);
            node.get(new String[]{"attributes", "entries", "value-type"}).set(ModelType.PROPERTY);
            node.get(new String[]{"attributes", "entries", "access-type"}).set(AttributeAccess.AccessType.READ_WRITE.toString());
            node.get(new String[]{"attributes", "entries", "restart-required"}).set(AttributeAccess.Flag.RESTART_NONE.toString());
            return node;
        }
    };
    static final DescriptionProvider PROPERTY_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            ResourceBundle resbundle = OSGiSubsystemProviders.getResourceBundle(locale);
            node.get("description").set(resbundle.getString("framework.property"));
            node.get(new String[]{"attributes", "value", "description"}).set(resbundle.getString("framework.property.value"));
            node.get(new String[]{"attributes", "value", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "value", "required"}).set(true);
            node.get(new String[]{"attributes", "value", "access-type"}).set(AttributeAccess.AccessType.READ_WRITE.toString());
            node.get(new String[]{"attributes", "value", "restart-required"}).set("all-services");
            return node;
        }
    };
    static final DescriptionProvider CAPABILITY_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            ResourceBundle resbundle = OSGiSubsystemProviders.getResourceBundle(locale);
            node.get("description").set(resbundle.getString("capability"));
            node.get(new String[]{"attributes", "startlevel", "description"}).set(resbundle.getString("capability.startlevel"));
            node.get(new String[]{"attributes", "startlevel", "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", "startlevel", "required"}).set(false);
            node.get(new String[]{"attributes", "startlevel", "access-type"}).set(AttributeAccess.AccessType.READ_WRITE.toString());
            node.get(new String[]{"attributes", "startlevel", "restart-required"}).set("all-services");
            return node;
        }
    };
    static final DescriptionProvider BUNDLE_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            ResourceBundle resbundle = OSGiSubsystemProviders.getResourceBundle(locale);
            node.get("description").set(resbundle.getString("bundle"));
            String storageRuntime = AttributeAccess.Storage.RUNTIME.toString();
            ModelNode idNode = new ModelNode();
            idNode.get("type").set(ModelType.LONG);
            idNode.get("description").set(resbundle.getString("bundle.id"));
            idNode.get("access-type").set("read-only");
            idNode.get("storage").set(storageRuntime);
            ModelNode startLevelNode = new ModelNode();
            startLevelNode.get("type").set(ModelType.INT);
            startLevelNode.get("description").set(resbundle.getString("bundle.startlevel"));
            startLevelNode.get("access-type").set("read-only");
            startLevelNode.get("required").set(false);
            startLevelNode.get("storage").set(storageRuntime);
            ModelNode symbolicNameNode = new ModelNode();
            symbolicNameNode.get("type").set(ModelType.STRING);
            symbolicNameNode.get("description").set(resbundle.getString("bundle.symbolic-name"));
            symbolicNameNode.get("access-type").set("read-only");
            symbolicNameNode.get("storage").set(storageRuntime);
            ModelNode versionNode = new ModelNode();
            versionNode.get("type").set(ModelType.STRING);
            versionNode.get("description").set(resbundle.getString("bundle.version"));
            versionNode.get("access-type").set("read-only");
            versionNode.get("storage").set(storageRuntime);
            node.get("attributes").get("id").set(idNode);
            node.get("attributes").get("startlevel").set(startLevelNode);
            node.get("attributes").get("symbolic-name").set(symbolicNameNode);
            node.get("attributes").get("version").set(versionNode);
            return node;
        }
    };

    OSGiSubsystemProviders() {
    }

    static ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle(RESOURCE_NAME, locale != null ? locale : Locale.getDefault());
    }
}

