/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.TreeSet;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.osgi.parser.Namespace;
import org.jboss.as.osgi.parser.Namespace11;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class OSGiSubsystemWriter
implements XMLStreamConstants,
XMLElementWriter<SubsystemMarshallingContext> {
    static OSGiSubsystemWriter INSTANCE = new OSGiSubsystemWriter();

    private OSGiSubsystemWriter() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        if (this.has(node, "activation")) {
            this.writeAttribute(writer, Namespace11.Attribute.ACTIVATION, node.get("activation"));
        }
        if (this.has(node, "configuration")) {
            ModelNode configuration = node.get("configuration");
            for (String pid : new TreeSet(configuration.keys())) {
                writer.writeStartElement(Namespace11.Element.CONFIGURATION.getLocalName());
                writer.writeAttribute(Namespace11.Attribute.PID.getLocalName(), pid);
                ModelNode entries = configuration.get(pid).get("entries");
                if (entries.isDefined()) {
                    for (String propKey : entries.keys()) {
                        String propValue = entries.get(propKey).asString();
                        writer.writeStartElement(Namespace11.Element.PROPERTY.getLocalName());
                        writer.writeAttribute(Namespace11.Attribute.NAME.getLocalName(), propKey);
                        writer.writeAttribute(Namespace11.Attribute.VALUE.getLocalName(), propValue);
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
        }
        if (this.has(node, "property")) {
            writer.writeStartElement(Namespace11.Element.PROPERTIES.getLocalName());
            ModelNode properties = node.get("property");
            for (String key : new TreeSet(properties.keys())) {
                String val = properties.get(key).get("value").asString();
                writer.writeStartElement(Namespace11.Element.PROPERTY.getLocalName());
                writer.writeAttribute(Namespace11.Attribute.NAME.getLocalName(), key);
                writer.writeCharacters(val);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.has(node, "capability")) {
            writer.writeStartElement(Namespace11.Element.CAPABILITIES.getLocalName());
            ModelNode modules = node.get("capability");
            for (String key : modules.keys()) {
                ModelNode moduleNode = modules.get(key);
                writer.writeEmptyElement(Namespace11.Element.CAPABILITY.getLocalName());
                writer.writeAttribute(Namespace11.Attribute.NAME.getLocalName(), key);
                if (!moduleNode.has("startlevel")) continue;
                this.writeAttribute(writer, Namespace11.Attribute.STARTLEVEL, moduleNode.require("startlevel"));
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private boolean has(ModelNode node, String name) {
        if (node.has(name) && node.get(name).isDefined()) {
            ModelNode n = node.get(name);
            switch (n.getType()) {
                case LIST: 
                case OBJECT: {
                    return n.asList().size() > 0;
                }
            }
            return true;
        }
        return false;
    }

    private void writeAttribute(XMLExtendedStreamWriter writer, Namespace11.Attribute attr, ModelNode value) throws XMLStreamException {
        writer.writeAttribute(attr.getLocalName(), value.asString());
    }
}

