/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.parser.OSGiSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.osgi.framework.Services;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;

public class BundleRuntimeHandler
extends AbstractRuntimeOnlyHandler {
    static final BundleRuntimeHandler INSTANCE = new BundleRuntimeHandler();
    static final String[] ATTRIBUTES = new String[]{"id", "startlevel", "state", "symbolic-name", "type", "version"};
    static final String START_OPERATION = "start";
    static final String STOP_OPERATION = "stop";
    static final String[] OPERATIONS = new String[]{"start", "stop"};

    private BundleRuntimeHandler() {
    }

    void register(ManagementResourceRegistration registry) {
        for (String attr : ATTRIBUTES) {
            registry.registerReadOnlyAttribute(attr, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (final String op : OPERATIONS) {
            registry.registerOperationHandler(op, (OperationStepHandler)this, new DescriptionProvider(){

                public ModelNode getModelDescription(Locale locale) {
                    ResourceBundle resouceBundle = OSGiSubsystemProviders.getResourceBundle(locale);
                    return CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)resouceBundle, (String)op, (String)"bundle");
                }
            }, EnumSet.of(OperationEntry.Flag.RESTART_NONE));
        }
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String operationName = operation.require("operation").asString();
        if ("read-attribute".equals(operationName)) {
            this.handleReadAttribute(context, operation);
        } else if (Arrays.asList(OPERATIONS).contains(operationName)) {
            this.handleOperation(operationName, context, operation);
        }
    }

    private void handleReadAttribute(OperationContext context, ModelNode operation) {
        String name = operation.require("name").asString();
        Long id = Long.parseLong(PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue());
        BundleContext bc = this.getBundleContext(context);
        Bundle bundle2 = bc.getBundle(id.longValue());
        if ("id".equals(name)) {
            context.getResult().set(id.longValue());
        } else if ("startlevel".equals(name)) {
            Integer startLevel = this.getStartLevel(bc, bundle2);
            if (startLevel != null) {
                context.getResult().set(startLevel.intValue());
            } else {
                context.getFailureDescription().set(OSGiMessages.MESSAGES.serviceNotAvailable());
            }
        } else if ("state".equals(name)) {
            context.getResult().set(BundleRuntimeHandler.getBundleState(bundle2));
        } else if ("symbolic-name".equals(name)) {
            context.getResult().set(bundle2.getSymbolicName());
        } else if ("type".equals(name)) {
            if (bundle2.getHeaders().get("Fragment-Host") != null) {
                context.getResult().set("fragment");
            } else {
                context.getResult().set("bundle");
            }
        } else if ("version".equals(name)) {
            context.getResult().set(bundle2.getVersion().toString());
        }
        context.completeStep();
    }

    private void handleOperation(String operationName, OperationContext context, ModelNode operation) {
        Long id = Long.parseLong(PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue());
        BundleContext bc = this.getBundleContext(context);
        Bundle bundle2 = bc.getBundle(id.longValue());
        try {
            if (START_OPERATION.equals(operationName)) {
                bundle2.start();
            } else if (STOP_OPERATION.equals(operationName)) {
                bundle2.stop();
            }
        }
        catch (BundleException e) {
            context.getFailureDescription().set(e.getLocalizedMessage());
        }
        context.completeStep();
    }

    static String getBundleState(Bundle bundle2) {
        switch (bundle2.getState()) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return null;
    }

    private BundleContext getBundleContext(OperationContext context) {
        ServiceController sbs = context.getServiceRegistry(false).getService(Services.SYSTEM_BUNDLE);
        if (sbs == null) {
            return null;
        }
        Bundle systemBundle = (Bundle)Bundle.class.cast(sbs.getValue());
        return systemBundle.getBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getStartLevel(BundleContext bc, Bundle b) {
        ServiceReference sref = bc.getServiceReference(StartLevel.class.getName());
        if (sref == null) {
            return null;
        }
        try {
            Object sls = bc.getService(sref);
            if (!(sls instanceof StartLevel)) {
                Integer n = null;
                return n;
            }
            Integer n = ((StartLevel)sls).getBundleStartLevel(b);
            return n;
        }
        finally {
            bc.ungetService(sref);
        }
    }
}

