/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.EnumSet;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.osgi.parser.ActivateOperationHandler;
import org.jboss.as.osgi.parser.ActivationAttributeHandler;
import org.jboss.as.osgi.parser.BundleRuntimeHandler;
import org.jboss.as.osgi.parser.Namespace;
import org.jboss.as.osgi.parser.OSGiCapabilityAdd;
import org.jboss.as.osgi.parser.OSGiCapabilityRemove;
import org.jboss.as.osgi.parser.OSGiConfigurationAdd;
import org.jboss.as.osgi.parser.OSGiConfigurationRemove;
import org.jboss.as.osgi.parser.OSGiFrameworkPropertyAdd;
import org.jboss.as.osgi.parser.OSGiFrameworkPropertyRemove;
import org.jboss.as.osgi.parser.OSGiFrameworkPropertyWrite;
import org.jboss.as.osgi.parser.OSGiNamespace10Parser;
import org.jboss.as.osgi.parser.OSGiNamespace11Parser;
import org.jboss.as.osgi.parser.OSGiSubsystemAdd;
import org.jboss.as.osgi.parser.OSGiSubsystemDescribeHandler;
import org.jboss.as.osgi.parser.OSGiSubsystemProviders;
import org.jboss.as.osgi.parser.OSGiSubsystemWriter;
import org.jboss.as.osgi.parser.StartLevelHandler;
import org.jboss.staxmapper.XMLElementWriter;

public class OSGiExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "osgi";

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.OSGI_1_0.getUriString(), OSGiNamespace10Parser.INSTANCE);
        context.setSubsystemXmlMapping(Namespace.OSGI_1_1.getUriString(), OSGiNamespace11Parser.INSTANCE);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(OSGiSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)OSGiSubsystemAdd.INSTANCE, OSGiSubsystemAdd.DESCRIPTION, false);
        registration.registerReadWriteAttribute("activation", null, (OperationStepHandler)ActivationAttributeHandler.INSTANCE, EnumSet.of(AttributeAccess.Flag.STORAGE_CONFIGURATION, AttributeAccess.Flag.RESTART_JVM));
        registration.registerReadWriteAttribute("startlevel", (OperationStepHandler)StartLevelHandler.READ_HANDLER, (OperationStepHandler)StartLevelHandler.WRITE_HANDLER, AttributeAccess.Storage.RUNTIME);
        registration.registerOperationHandler("activate", (OperationStepHandler)ActivateOperationHandler.INSTANCE, (DescriptionProvider)ActivateOperationHandler.INSTANCE, EnumSet.of(OperationEntry.Flag.RESTART_NONE));
        registration.registerOperationHandler("describe", (OperationStepHandler)OSGiSubsystemDescribeHandler.INSTANCE, OSGiSubsystemAdd.DESCRIPTION, false, OperationEntry.EntryType.PRIVATE);
        ManagementResourceRegistration configuration = registration.registerSubModel(PathElement.pathElement((String)"configuration"), OSGiSubsystemProviders.CONFIGURATION_DESCRIPTION);
        configuration.registerOperationHandler("add", (OperationStepHandler)OSGiConfigurationAdd.INSTANCE, OSGiConfigurationAdd.DESCRIPTION, false);
        configuration.registerOperationHandler("remove", (OperationStepHandler)OSGiConfigurationRemove.INSTANCE, OSGiConfigurationRemove.DESCRIPTION, false);
        ManagementResourceRegistration properties = registration.registerSubModel(PathElement.pathElement((String)"property"), OSGiSubsystemProviders.PROPERTY_DESCRIPTION);
        properties.registerOperationHandler("add", (OperationStepHandler)OSGiFrameworkPropertyAdd.INSTANCE, OSGiFrameworkPropertyAdd.DESCRIPTION, false);
        properties.registerOperationHandler("remove", (OperationStepHandler)OSGiFrameworkPropertyRemove.INSTANCE, OSGiFrameworkPropertyRemove.DESCRIPTION, false);
        properties.registerReadWriteAttribute("value", null, (OperationStepHandler)OSGiFrameworkPropertyWrite.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration capabilities = registration.registerSubModel(PathElement.pathElement((String)"capability"), OSGiSubsystemProviders.CAPABILITY_DESCRIPTION);
        capabilities.registerOperationHandler("add", (OperationStepHandler)OSGiCapabilityAdd.INSTANCE, OSGiCapabilityAdd.DESCRIPTION, false);
        capabilities.registerOperationHandler("remove", (OperationStepHandler)OSGiCapabilityRemove.INSTANCE, OSGiCapabilityRemove.DESCRIPTION, false);
        if (context.getProcessType().isServer()) {
            ManagementResourceRegistration bundles = registration.registerSubModel(PathElement.pathElement((String)"bundle"), OSGiSubsystemProviders.BUNDLE_DESCRIPTION);
            BundleRuntimeHandler.INSTANCE.register(bundles);
        }
        subsystem.registerXMLElementWriter((XMLElementWriter)OSGiSubsystemWriter.INSTANCE);
    }
}

