/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.osgi.parser.OSGiSubsystemProviders;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class OSGiCapabilityAdd
extends AbstractAddStepHandler {
    static final OSGiCapabilityAdd INSTANCE = new OSGiCapabilityAdd();
    static DescriptionProvider DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            ResourceBundle resourceBundle = OSGiSubsystemProviders.getResourceBundle(locale);
            node.get("operation-name").set("add");
            node.get("description").set(resourceBundle.getString("capability.add"));
            this.addModelProperties(resourceBundle, node, "request-properties");
            node.get("reply-properties").setEmptyObject();
            return node;
        }

        private void addModelProperties(ResourceBundle bundle2, ModelNode node, String propType) {
            node.get(new String[]{propType, "startlevel", "description"}).set(bundle2.getString("capability.startlevel"));
            node.get(new String[]{propType, "startlevel", "type"}).set(ModelType.INT);
            node.get(new String[]{propType, "startlevel", "required"}).set(false);
        }
    };

    private OSGiCapabilityAdd() {
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getType() == OperationContext.Type.SERVER || context.getType() == OperationContext.Type.HOST;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        if (operation.has("startlevel")) {
            model.get("startlevel").set(operation.get("startlevel"));
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode slNode = null;
        if (operation.has("startlevel")) {
            slNode = operation.get("startlevel");
            model.get("startlevel").set(slNode);
        }
        Integer startLevel = slNode != null ? Integer.valueOf(slNode.asInt()) : null;
        String identifier = operation.get("address").asObject().get("capability").asString();
        SubsystemState.OSGiCapability module = new SubsystemState.OSGiCapability(identifier, startLevel);
        SubsystemState subsystemState = SubsystemState.getSubsystemState(context);
        if (subsystemState != null) {
            subsystemState.addCapability(module);
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        String identifier = operation.get("address").asObject().get("capability").asString();
        SubsystemState subsystemState = SubsystemState.getSubsystemState(context);
        if (subsystemState != null) {
            subsystemState.removeCapability(identifier);
        }
    }
}

