/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.deployment.BundleInstallService;
import org.jboss.as.osgi.deployment.OSGiDeploymentAttachment;
import org.jboss.as.osgi.deployment.PersistentBundleInstallService;
import org.jboss.as.osgi.service.PersistentBundlesIntegration;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.Services;

public class BundleInstallProcessor
implements DeploymentUnitProcessor {
    static final AttachmentKey<ServiceName> INSTALL_SERVICE_NAME_KEY = AttachmentKey.create(ServiceName.class);
    private final PersistentBundlesIntegration.InitialDeploymentTracker deploymentTracker;
    private final AtomicBoolean frameworkActivated = new AtomicBoolean();

    public BundleInstallProcessor(PersistentBundlesIntegration.InitialDeploymentTracker deploymentTracker) {
        this.deploymentTracker = deploymentTracker;
    }

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = context.getDeploymentUnit();
        Deployment deployment = OSGiDeploymentAttachment.getDeployment(depUnit);
        if (deployment != null) {
            ServiceName serviceName;
            if (this.frameworkActivated.compareAndSet(false, true)) {
                this.activateFramework(context);
            }
            if (!this.deploymentTracker.isClosed() && this.deploymentTracker.hasDeploymentName(depUnit.getName())) {
                serviceName = PersistentBundleInstallService.addService(this.deploymentTracker, context, deployment);
                this.deploymentTracker.registerBundleInstallService(serviceName);
            } else {
                serviceName = BundleInstallService.addService(context, deployment);
            }
            depUnit.putAttachment(INSTALL_SERVICE_NAME_KEY, (Object)serviceName);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
        ServiceController serviceController;
        ServiceName serviceName = (ServiceName)depUnit.getAttachment(INSTALL_SERVICE_NAME_KEY);
        if (serviceName != null && (serviceController = depUnit.getServiceRegistry().getService(serviceName)) != null) {
            serviceController.setMode(ServiceController.Mode.REMOVE);
        }
    }

    private void activateFramework(DeploymentPhaseContext context) {
        AbstractService<Void> service = new AbstractService<Void>(){

            public void start(StartContext context) throws StartException {
                context.getController().setMode(ServiceController.Mode.REMOVE);
            }
        };
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceBuilder builder = serviceTarget.addService(OSGiConstants.FRAMEWORK_BASE_NAME.append(new String[]{"ACTIVATE"}), (Service)service);
        builder.addDependency(Services.FRAMEWORK_ACTIVATOR);
        builder.install();
    }
}

