/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.jboss.osgi.resolver.XResourceBuilderFactory;

public class ModuleRegisterService
implements Service<ModuleRegisterService> {
    public static final ServiceName SERVICE_NAME_BASE = OSGiConstants.SERVICE_BASE_NAME.append(new String[]{"module", "registration"});
    private final Module module;
    private final OSGiMetaData metadata;
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private XResource resource;

    private ModuleRegisterService(Module module, OSGiMetaData metadata) {
        this.module = module;
        this.metadata = metadata;
    }

    public static void addService(DeploymentPhaseContext phaseContext, Module module, OSGiMetaData metadata) {
        ModuleRegisterService service = new ModuleRegisterService(module, metadata);
        ServiceName serviceName = ModuleRegisterService.getServiceName(module.getIdentifier());
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, service.injectedEnvironment);
        builder.addDependency(ServiceModuleLoader.moduleServiceName((ModuleIdentifier)module.getIdentifier()));
        builder.install();
    }

    public static void removeService(DeploymentUnit deploymentUnit) {
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServiceName serviceName = ModuleRegisterService.getServiceName(module.getIdentifier());
        ServiceController serviceController = deploymentUnit.getServiceRegistry().getService(serviceName);
        if (serviceController != null) {
            serviceController.setMode(ServiceController.Mode.REMOVE);
        }
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", controller.getName(), controller.getMode());
        OSGiLogger.LOGGER.infoRegisterModule(this.module);
        try {
            XResourceBuilder builder = XResourceBuilderFactory.create();
            if (this.metadata != null) {
                builder.loadFrom(this.metadata);
            } else {
                builder.loadFrom(this.module);
            }
            this.resource = builder.getResource();
            this.resource.addAttachment(Module.class, (Object)this.module);
            ((XEnvironment)this.injectedEnvironment.getValue()).installResources(new XResource[]{this.resource});
        }
        catch (Throwable th) {
            throw OSGiMessages.MESSAGES.startFailedToRegisterModule(th, this.module);
        }
    }

    public synchronized void stop(StopContext context) {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Stopping: %s in mode %s", controller.getName(), controller.getMode());
        if (this.resource != null) {
            OSGiLogger.LOGGER.infoUnregisterModule(this.module);
            ((XEnvironment)this.injectedEnvironment.getValue()).uninstallResources(new XResource[]{this.resource});
        }
    }

    public ModuleRegisterService getValue() throws IllegalStateException {
        return this;
    }

    private static ServiceName getServiceName(ModuleIdentifier moduleIdentifier) {
        return SERVICE_NAME_BASE.append(new String[]{moduleIdentifier.toString()});
    }
}

