/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.vfs.VirtualFile;

public class OSGiXServiceParseProcessor
implements DeploymentUnitProcessor {
    public static final String XSERVICE_PROPERTIES_NAME = "META-INF/jbosgi-xservice.properties";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        OSGiMetaData metadata = (OSGiMetaData)depUnit.getAttachment(OSGiConstants.OSGI_METADATA_KEY);
        if (metadata != null) {
            return;
        }
        VirtualFile virtualFile = ((ResourceRoot)depUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        VirtualFile xserviceFile = virtualFile.getChild(XSERVICE_PROPERTIES_NAME);
        if (!xserviceFile.exists()) {
            return;
        }
        try {
            metadata = OSGiMetaDataBuilder.load((InputStream)xserviceFile.openStream());
            depUnit.putAttachment(OSGiConstants.OSGI_METADATA_KEY, (Object)metadata);
        }
        catch (IOException ex) {
            throw OSGiMessages.MESSAGES.cannotParseOSGiMetadata(ex, xserviceFile);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
        depUnit.removeAttachment(OSGiConstants.OSGI_METADATA_KEY);
    }
}

