/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.List;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.service.FrameworkActivator;
import org.jboss.as.osgi.service.InitialDeploymentTracker;
import org.jboss.as.osgi.service.ModuleRegistrationTracker;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.Services;

public class FrameworkActivateProcessor
implements DeploymentUnitProcessor {
    private final InitialDeploymentTracker deploymentTracker;

    public FrameworkActivateProcessor(InitialDeploymentTracker deploymentTracker) {
        this.deploymentTracker = deploymentTracker;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        Deployment deployment = (Deployment)depUnit.getAttachment(OSGiConstants.DEPLOYMENT_KEY);
        boolean hasInjectionPoint = this.hasValidInjectionPoint(depUnit);
        if (deployment == null && !hasInjectionPoint) {
            return;
        }
        FrameworkActivator.activate((ServiceVerificationHandler)depUnit.getAttachment(Attachments.SERVICE_VERIFICATION_HANDLER));
        if (this.deploymentTracker.isComplete()) {
            phaseContext.addDeploymentDependency(Services.FRAMEWORK_ACTIVE, AttachmentKey.create(Object.class));
        } else {
            phaseContext.addDeploymentDependency(ModuleRegistrationTracker.MODULE_REGISTRATION_COMPLETE, AttachmentKey.create(Object.class));
            phaseContext.addDeploymentDependency(Services.FRAMEWORK_CREATE, OSGiConstants.SYSTEM_CONTEXT_KEY);
        }
        phaseContext.addDeploymentDependency(Services.BUNDLE_MANAGER, OSGiConstants.BUNDLE_MANAGER_KEY);
        phaseContext.addDeploymentDependency(Services.RESOLVER, OSGiConstants.RESOLVER_KEY);
        phaseContext.addDeploymentDependency(Services.ENVIRONMENT, OSGiConstants.ENVIRONMENT_KEY);
    }

    public void undeploy(DeploymentUnit depUnit) {
    }

    private boolean hasValidInjectionPoint(DeploymentUnit depUnit) {
        return this.hasInjectionPoint(depUnit, "javax.inject.Inject") || this.hasInjectionPoint(depUnit, "javax.annotation.Resource");
    }

    private boolean hasInjectionPoint(DeploymentUnit depUnit, String anName) {
        boolean result = false;
        CompositeIndex compositeIndex = (CompositeIndex)depUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        List annotationList = compositeIndex.getAnnotations(DotName.createSimple((String)anName));
        for (AnnotationInstance instance : annotationList) {
            FieldInfo fieldInfo;
            String typeName;
            AnnotationTarget target = instance.target();
            if (!(target instanceof FieldInfo) || !(typeName = (fieldInfo = (FieldInfo)target).type().toString()).startsWith("org.osgi.framework") && !typeName.startsWith("org.osgi.service")) continue;
            OSGiLogger.LOGGER.debugf("OSGi injection point of type '%s' detected: %s", typeName, fieldInfo.declaringClass());
            result = true;
            break;
        }
        return result;
    }
}

