/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.net.InetSocketAddress;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.SubsystemExtension;
import org.jboss.as.osgi.management.OSGiRuntimeResource;
import org.jboss.as.server.Services;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.SystemServices;
import org.jboss.osgi.framework.spi.SystemServicesPlugin;
import org.jboss.osgi.repository.XRepository;
import org.osgi.framework.BundleContext;

final class SystemServicesIntegration
extends SystemServicesPlugin {
    private final InjectedValue<ModelController> injectedModelController = new InjectedValue();
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<BundleContext> injectedBundleContext = new InjectedValue();
    private final InjectedValue<XRepository> injectedRepository = new InjectedValue();
    private final List<SubsystemExtension> extensions;
    private final OSGiRuntimeResource resource;
    private ServiceContainer serviceContainer;
    private ExecutorService controllerThreadExecutor;

    SystemServicesIntegration(OSGiRuntimeResource resource, List<SubsystemExtension> extensions) {
        this.extensions = extensions;
        this.resource = resource;
    }

    protected void addServiceDependencies(ServiceBuilder<SystemServices> builder) {
        super.addServiceDependencies(builder);
        builder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, this.injectedModelController);
        builder.addDependency(org.jboss.osgi.framework.Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(org.jboss.osgi.framework.Services.FRAMEWORK_CREATE, BundleContext.class, this.injectedBundleContext);
        builder.addDependency(OSGiConstants.REPOSITORY_SERVICE_NAME, XRepository.class, this.injectedRepository);
        for (SubsystemExtension extension : this.extensions) {
            extension.configureServiceDependencies(this.getServiceName(), builder);
        }
    }

    public void start(StartContext startContext) throws StartException {
        this.serviceContainer = startContext.getController().getServiceContainer();
        super.start(startContext);
        BundleContext syscontext = (BundleContext)this.injectedBundleContext.getValue();
        for (SubsystemExtension extension : this.extensions) {
            extension.startSystemServices(startContext, syscontext);
        }
    }

    public void stop(StopContext context) {
        BundleContext syscontext = (BundleContext)this.injectedBundleContext.getValue();
        for (SubsystemExtension extension : this.extensions) {
            extension.stopSystemServices(context, syscontext);
        }
        ((SystemServices)this.getValue()).unregisterServices();
    }

    protected SystemServices createServiceValue(StartContext startContext) throws StartException {
        return new SystemServicesImpl();
    }

    class SystemServicesImpl
    implements SystemServices {
        SystemServicesImpl() {
        }

        public void registerServices(final BundleContext syscontext) {
            BundleManager bundleManager = (BundleManager)SystemServicesIntegration.this.injectedBundleManager.getValue();
            SystemServicesIntegration.this.resource.getInjectedBundleManager().inject((Object)bundleManager);
            String bindingNames = syscontext.getProperty("org.jboss.as.osgi.socket.bindings");
            if (bindingNames != null) {
                final HashSet<ServiceName> socketBindingNames = new HashSet<ServiceName>();
                for (String suffix : bindingNames.split(",")) {
                    socketBindingNames.add(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{suffix}));
                }
                ServiceTarget serviceTarget = bundleManager.getServiceTarget();
                ServiceName serviceName = IntegrationServices.SYSTEM_SERVICES_PLUGIN.append(new String[]{"BINDINGS"});
                ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)new AbstractService<Void>(){

                    public void start(StartContext context) throws StartException {
                        for (ServiceName serviceName : socketBindingNames) {
                            SocketBinding binding = (SocketBinding)SystemServicesIntegration.this.serviceContainer.getRequiredService(serviceName).getValue();
                            Hashtable<String, String> props = new Hashtable<String, String>();
                            ((Dictionary)props).put("socketBinding", serviceName.getSimpleName());
                            InetSocketAddress value = binding.getSocketAddress();
                            syscontext.registerService(InetSocketAddress.class.getName(), (Object)value, props);
                        }
                    }
                });
                ServiceName[] serviceNameArray = socketBindingNames.toArray(new ServiceName[socketBindingNames.size()]);
                builder.addDependencies(serviceNameArray);
                builder.install();
            }
            SystemServicesIntegration.this.controllerThreadExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable run) {
                    Thread thread = new Thread(run);
                    thread.setName("OSGi ModelControllerClient Thread");
                    thread.setDaemon(true);
                    return thread;
                }
            });
            ModelController modelController = (ModelController)SystemServicesIntegration.this.injectedModelController.getValue();
            ModelControllerClient client = modelController.createClient((Executor)SystemServicesIntegration.this.controllerThreadExecutor);
            syscontext.registerService(ModelControllerClient.class.getName(), (Object)client, null);
            syscontext.registerService(ServiceContainer.class.getName(), (Object)SystemServicesIntegration.this.serviceContainer, null);
        }

        public void unregisterServices() {
            SystemServicesIntegration.this.resource.getInjectedBundleManager().uninject();
            SystemServicesIntegration.this.controllerThreadExecutor.shutdown();
        }
    }
}

