/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.module.MountHandle;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.as.osgi.deployment.BundleInfoAttachment;
import org.jboss.as.osgi.deployment.DeploymentAttachment;
import org.jboss.as.osgi.deployment.OSGiDeploymentService;
import org.jboss.as.osgi.deployment.OSGiMetaDataAttachment;
import org.jboss.as.osgi.deployment.XModuleAttachment;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Version;

public class OSGiAttachmentsDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.INSTALL_SERVICES.plus(100L);

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        Deployment deployment = DeploymentAttachment.getDeploymentAttachment(context);
        BundleInfo info = BundleInfoAttachment.getBundleInfoAttachment(context);
        if (deployment == null && info != null) {
            deployment = DeploymentFactory.createDeployment((BundleInfo)info);
            deployment.addAttachment(BundleInfo.class, (Object)info);
            DeploymentAttachment.attachDeployment(context, deployment);
        }
        OSGiMetaData metadata = OSGiMetaDataAttachment.getOSGiMetaDataAttachment(context);
        if (deployment == null && metadata != null) {
            org.jboss.vfs.VirtualFile virtualFile = VirtualFileAttachment.getVirtualFileAttachment((DeploymentUnitContext)context);
            String location = virtualFile.getPathName();
            String symbolicName = metadata.getBundleSymbolicName();
            Version version = metadata.getBundleVersion();
            deployment = DeploymentFactory.createDeployment((VirtualFile)AbstractVFS.adapt((Object)virtualFile), (String)location, (String)symbolicName, (Version)version);
            deployment.addAttachment(OSGiMetaData.class, (Object)metadata);
            DeploymentAttachment.attachDeployment(context, deployment);
        }
        XModule resModule = XModuleAttachment.getXModuleAttachment(context);
        if (deployment == null && resModule != null) {
            org.jboss.vfs.VirtualFile virtualFile = VirtualFileAttachment.getVirtualFileAttachment((DeploymentUnitContext)context);
            String location = virtualFile.getPathName();
            String symbolicName = resModule.getName();
            Version version = resModule.getVersion();
            deployment = DeploymentFactory.createDeployment((VirtualFile)AbstractVFS.adapt((Object)virtualFile), (String)location, (String)symbolicName, (Version)version);
            deployment.addAttachment(XModule.class, (Object)resModule);
            DeploymentAttachment.attachDeployment(context, deployment);
        }
        if (deployment != null) {
            MountHandle mount = (MountHandle)context.getAttachment(MountHandle.ATTACHMENT_KEY);
            deployment.addAttachment(MountHandle.class, (Object)mount);
            OSGiDeploymentService.addService(context);
        }
    }
}

