/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.deployment.chain.DeploymentChain;
import org.jboss.as.deployment.chain.DeploymentChainImpl;
import org.jboss.as.deployment.chain.DeploymentChainProcessorInjector;
import org.jboss.as.deployment.chain.DeploymentChainProvider;
import org.jboss.as.deployment.chain.DeploymentChainProviderInjector;
import org.jboss.as.deployment.chain.DeploymentChainProviderService;
import org.jboss.as.deployment.chain.DeploymentChainService;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.as.deployment.unit.DeploymentUnitProcessorService;
import org.jboss.as.osgi.deployment.OSGiAttachmentsDeploymentProcessor;
import org.jboss.as.osgi.deployment.OSGiDeploymentChainSelector;
import org.jboss.as.osgi.deployment.OSGiManifestDeploymentProcessor;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public class OSGiDeploymentActivator {
    public static final long OSGI_DEPLOYMENT_CHAIN_PRIORITY = 1000001000L;
    public static final ServiceName OSGI_DEPLOYMENT_CHAIN_SERVICE_NAME = DeploymentChain.SERVICE_NAME.append(new String[]{"osgi"});

    public void activate(BatchBuilder batchBuilder) {
        batchBuilder.addServiceValueIfNotExist(DeploymentChainProviderService.SERVICE_NAME, (Value)new DeploymentChainProviderService());
        Value deploymentChainValue = Values.immediateValue((Object)new DeploymentChainImpl(OSGI_DEPLOYMENT_CHAIN_SERVICE_NAME.toString()));
        DeploymentChainService deploymentChainService = new DeploymentChainService(deploymentChainValue);
        BatchServiceBuilder serviceBuilder = batchBuilder.addService(OSGI_DEPLOYMENT_CHAIN_SERVICE_NAME, (Service)deploymentChainService);
        DeploymentChainProviderInjector injector = new DeploymentChainProviderInjector(deploymentChainValue, (DeploymentChainProvider.Selector)new OSGiDeploymentChainSelector(), 1000001000L);
        serviceBuilder.addDependency(DeploymentChainProviderService.SERVICE_NAME, DeploymentChainProvider.class, (Injector)injector);
        this.addDeploymentProcessor(batchBuilder, new OSGiManifestDeploymentProcessor(), OSGiManifestDeploymentProcessor.PRIORITY);
        this.addDeploymentProcessor(batchBuilder, new OSGiAttachmentsDeploymentProcessor(), OSGiAttachmentsDeploymentProcessor.PRIORITY);
    }

    private <T extends DeploymentUnitProcessor> BatchServiceBuilder<T> addDeploymentProcessor(BatchBuilder batchBuilder, T deploymentUnitProcessor, long priority) {
        DeploymentUnitProcessorService deploymentUnitProcessorService = new DeploymentUnitProcessorService(deploymentUnitProcessor);
        ServiceName serviceName = OSGI_DEPLOYMENT_CHAIN_SERVICE_NAME.append(new String[]{deploymentUnitProcessor.getClass().getName()});
        BatchServiceBuilder serviceBuilder = batchBuilder.addService(serviceName, (Service)deploymentUnitProcessorService);
        DeploymentChainProcessorInjector injector = new DeploymentChainProcessorInjector((Value)deploymentUnitProcessorService, priority);
        return serviceBuilder.addDependency(OSGI_DEPLOYMENT_CHAIN_SERVICE_NAME, DeploymentChain.class, (Injector)injector);
    }
}

