/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.as.deployment.DeploymentService;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.osgi.deployment.DeploymentAttachment;
import org.jboss.as.osgi.service.FrameworkService;
import org.jboss.as.osgi.service.PackageAdminService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class OSGiDeploymentService
implements Service<Deployment> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    private static final OSGiDeploymentListener listener = new OSGiDeploymentListener();
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"osgi", "deployment"});
    public static boolean enableListener = true;
    private final Deployment deployment;
    private InjectedValue<BundleContext> injectedContext = new InjectedValue();

    private OSGiDeploymentService(Deployment deployment) {
        this.deployment = deployment;
    }

    public static void addService(DeploymentUnitContext context) {
        ServiceName deploymentServiceName = DeploymentService.getServiceName((String)context.getName());
        Deployment deployment = DeploymentAttachment.getDeploymentAttachment(context);
        deployment.addAttachment(ServiceName.class, (Object)deploymentServiceName);
        BatchBuilder batchBuilder = context.getBatchBuilder();
        OSGiDeploymentService service = new OSGiDeploymentService(deployment);
        ServiceName serviceName = SERVICE_NAME.append(new String[]{deploymentServiceName.getSimpleName()});
        BatchServiceBuilder serviceBuilder = batchBuilder.addService(serviceName, (Service)service);
        serviceBuilder.addDependency(FrameworkService.SERVICE_NAME, BundleContext.class, service.injectedContext);
        serviceBuilder.addDependency(PackageAdminService.SERVICE_NAME);
        serviceBuilder.addDependency(deploymentServiceName);
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        if (enableListener) {
            serviceBuilder.addListener((ServiceListener)listener);
        }
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        ServiceContainer serviceContainer = controller.getServiceContainer();
        ServiceController frameworkController = serviceContainer.getService(FrameworkService.SERVICE_NAME);
        frameworkController.setMode(ServiceController.Mode.ACTIVE);
        log.tracef("Installing deployment: %s", (Object)this.deployment);
        try {
            boolean autoStart = this.deployment.isAutoStart();
            this.deployment.setAutoStart(false);
            Bundle bundle = this.getDeployerService().deploy(this.deployment);
            this.deployment.addAttachment(Bundle.class, (Object)bundle);
            this.deployment.setAutoStart(autoStart);
        }
        catch (Throwable t) {
            throw new StartException("Failed to install deployment: " + this.deployment, t);
        }
    }

    public synchronized void stop(StopContext context) {
        log.tracef("Uninstalling deployment: %s", (Object)this.deployment);
        try {
            this.getDeployerService().undeploy(this.deployment);
        }
        catch (Throwable t) {
            log.errorf(t, "Failed to uninstall deployment: %s", (Object)this.deployment);
        }
    }

    public Deployment getValue() throws IllegalStateException {
        return this.deployment;
    }

    private DeployerService getDeployerService() {
        BundleContext sysContext = (BundleContext)this.injectedContext.getValue();
        ServiceReference sref = sysContext.getServiceReference(DeployerService.class.getName());
        return (DeployerService)sysContext.getService(sref);
    }

    static class OSGiDeploymentListener
    extends AbstractServiceListener<Deployment> {
        private final Set<Deployment> startedDeployments = new CopyOnWriteArraySet<Deployment>();
        private final Set<Deployment> pendingDeployments = new CopyOnWriteArraySet<Deployment>();

        OSGiDeploymentListener() {
        }

        public void listenerAdded(ServiceController<? extends Deployment> controller) {
            this.pendingDeployments.add((Deployment)controller.getValue());
        }

        public void serviceStarted(ServiceController<? extends Deployment> controller) {
            this.startedDeployments.add((Deployment)controller.getValue());
            this.processDeployment(controller);
        }

        public void serviceFailed(ServiceController<? extends Deployment> controller, StartException reason) {
            this.processDeployment(controller);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processDeployment(ServiceController<? extends Deployment> controller) {
            controller.removeListener((ServiceListener)this);
            HashSet<Deployment> bundlesToStart = null;
            OSGiDeploymentListener oSGiDeploymentListener = this;
            synchronized (oSGiDeploymentListener) {
                this.pendingDeployments.remove(controller.getValue());
                if (this.pendingDeployments.isEmpty()) {
                    bundlesToStart = new HashSet<Deployment>(this.startedDeployments);
                    this.startedDeployments.clear();
                }
            }
            if (bundlesToStart != null) {
                ServiceContainer serviceContainer = controller.getServiceContainer();
                PackageAdmin packageAdmin = PackageAdminService.getServiceValue(serviceContainer);
                for (Deployment deployment : bundlesToStart) {
                    Bundle bundle = (Bundle)deployment.getAttachment(Bundle.class);
                    if (packageAdmin.getBundleType(bundle) == 1) continue;
                    log.tracef("Starting bundle: %s", (Object)bundle);
                    try {
                        bundle.start();
                    }
                    catch (BundleException ex) {
                        log.errorf((Throwable)ex, "Cannot start bundle: %s", (Object)bundle);
                    }
                }
            }
        }
    }
}

