/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.io.IOException;
import java.util.jar.Manifest;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.attachment.ManifestAttachment;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.as.osgi.deployment.BundleInfoAttachment;
import org.jboss.as.osgi.deployment.DeploymentAttachment;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.vfs.VFSUtils;
import org.osgi.framework.BundleException;

public class OSGiManifestDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.PARSE_DESCRIPTORS.plus(100L);

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        Deployment deployment = DeploymentAttachment.getDeploymentAttachment(context);
        if (deployment != null) {
            return;
        }
        org.jboss.vfs.VirtualFile virtualFile = VirtualFileAttachment.getVirtualFileAttachment((DeploymentUnitContext)context);
        Manifest manifest = ManifestAttachment.getManifestAttachment((DeploymentUnitContext)context);
        if (manifest == null) {
            try {
                manifest = VFSUtils.getManifest((org.jboss.vfs.VirtualFile)virtualFile);
                if (manifest != null) {
                    ManifestAttachment.attachManifest((DeploymentUnitContext)context, (Manifest)manifest);
                }
            }
            catch (IOException ex) {
                throw new DeploymentUnitProcessingException("Cannot read manifest from: " + virtualFile);
            }
        }
        if (BundleInfo.isValidateBundleManifest((Manifest)manifest)) {
            try {
                BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)AbstractVFS.adapt((Object)virtualFile));
                deployment = DeploymentFactory.createDeployment((BundleInfo)info);
                BundleInfoAttachment.attachBundleInfo(context, info);
                DeploymentAttachment.attachDeployment(context, deployment);
            }
            catch (BundleException ex) {
                throw new DeploymentUnitProcessingException("Cannot create bundle deployment from: " + virtualFile);
            }
        }
    }
}

