/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.osgi.deployment.OSGiDeploymentActivator;
import org.jboss.as.osgi.parser.OSGiSubsystemElement;
import org.jboss.as.osgi.parser.OSGiSubsystemState;
import org.jboss.as.osgi.service.BundleManagerService;
import org.jboss.as.osgi.service.Configuration;
import org.jboss.as.osgi.service.FrameworkService;
import org.jboss.as.osgi.service.PackageAdminService;
import org.jboss.as.util.SystemPropertyActions;
import org.jboss.logging.Logger;
import org.jboss.msc.service.BatchBuilder;

public final class OSGiSubsystemAdd
extends AbstractSubsystemAdd<OSGiSubsystemElement> {
    private static final long serialVersionUID = -4542570180370773590L;
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    private OSGiSubsystemState subsystemState = new OSGiSubsystemState();

    protected OSGiSubsystemAdd() {
        super("urn:jboss:domain:osgi:1.0");
    }

    protected OSGiSubsystemElement createSubsystemElement() {
        return new OSGiSubsystemElement();
    }

    OSGiSubsystemState getSubsystemState() {
        return this.subsystemState;
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        log.infof("Activating OSGi Subsystem", new Object[0]);
        String value = SystemPropertyActions.getProperty((String)"jboss.protocol.handler.modules", (String)"org.jboss.osgi.framework");
        if (!value.equals("org.jboss.osgi.framework")) {
            value = value + "|org.jboss.osgi.framework";
        }
        System.setProperty("jboss.protocol.handler.modules", value);
        OSGiSubsystemState.Activation policy = this.subsystemState.getActivationPolicy();
        BatchBuilder batchBuilder = updateContext.getBatchBuilder();
        Configuration.addService(batchBuilder, this.subsystemState);
        BundleManagerService.addService(batchBuilder);
        FrameworkService.addService(batchBuilder, policy);
        PackageAdminService.addService(batchBuilder);
        new OSGiDeploymentActivator().activate(batchBuilder);
    }
}

