/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.osgi.parser.OSGiSubsystemState;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class Configuration
implements Service<Configuration> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"osgi", "configuration"});
    static final String PROP_JBOSS_OSGI_SYSTEM_MODULES = "org.jboss.osgi.system.modules";
    private InjectedValue<ServerEnvironment> injectedEnvironment = new InjectedValue();
    private final OSGiSubsystemState subsystemState;

    public static void addService(BatchBuilder batchBuilder, OSGiSubsystemState state) {
        Configuration config = new Configuration(state);
        BatchServiceBuilder serviceBuilder = batchBuilder.addService(SERVICE_NAME, (Service)config);
        serviceBuilder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, config.injectedEnvironment);
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
    }

    public static Configuration getServiceValue(ServiceContainer container) {
        try {
            ServiceController controller = container.getRequiredService(SERVICE_NAME);
            return (Configuration)controller.getValue();
        }
        catch (ServiceNotFoundException ex) {
            throw new IllegalStateException("Cannot obtain required service: " + SERVICE_NAME);
        }
    }

    private Configuration(OSGiSubsystemState state) {
        this.subsystemState = state;
    }

    public OSGiSubsystemState.Activation getActivationPolicy() {
        return this.subsystemState.getActivationPolicy();
    }

    public Map<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(this.subsystemState.getProperties());
        String storage = (String)properties.get("org.osgi.framework.storage");
        if (storage == null) {
            ServerEnvironment envirionment = (ServerEnvironment)this.injectedEnvironment.getValue();
            File dataDir = envirionment.getServerDataDir();
            storage = dataDir.getAbsolutePath() + File.separator + "osgi-store";
            properties.put("org.osgi.framework.storage", storage);
        }
        return Collections.unmodifiableMap(properties);
    }

    public List<OSGiSubsystemState.OSGiModule> getModules() {
        return this.subsystemState.getModules();
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public Configuration getValue() throws IllegalStateException {
        return this;
    }

    public String toString() {
        return "OSGiServiceConfiguration: " + this.subsystemState;
    }
}

