/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.util.ArrayList;
import javax.management.MBeanServer;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.osgi.parser.OSGiSubsystemState;
import org.jboss.as.osgi.service.BundleManagerService;
import org.jboss.as.osgi.service.Configuration;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.AbstractUserBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.plugin.BundleDeploymentPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.launch.Framework;

public class FrameworkService
implements Service<BundleContext> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"osgi", "framework"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    private InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private InjectedValue<MBeanServer> injectedMBeanServer = new InjectedValue();
    private InjectedValue<Configuration> injectedConfig = new InjectedValue();
    private Framework framework;

    public static void addService(BatchBuilder batchBuilder, OSGiSubsystemState.Activation policy) {
        FrameworkService service = new FrameworkService();
        BatchServiceBuilder serviceBuilder = batchBuilder.addService(SERVICE_NAME, (Service)service);
        serviceBuilder.addDependency(BundleManagerService.SERVICE_NAME, BundleManager.class, service.injectedBundleManager);
        serviceBuilder.addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, service.injectedMBeanServer);
        serviceBuilder.addDependency(Configuration.SERVICE_NAME, Configuration.class, service.injectedConfig);
        serviceBuilder.setInitialMode(policy == OSGiSubsystemState.Activation.LAZY ? ServiceController.Mode.ON_DEMAND : ServiceController.Mode.ACTIVE);
    }

    public static BundleContext getServiceValue(ServiceContainer container) {
        try {
            ServiceController controller = container.getRequiredService(SERVICE_NAME);
            return (BundleContext)controller.getValue();
        }
        catch (ServiceNotFoundException ex) {
            throw new IllegalStateException("Cannot obtain required service: " + SERVICE_NAME);
        }
    }

    public synchronized void start(StartContext context) throws StartException {
        log.infof("Starting OSGi Framework", new Object[0]);
        try {
            final ServiceContainer serviceContainer = context.getController().getServiceContainer();
            BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
            this.framework = bundleManager.getFrameworkState();
            this.framework.start();
            BundleContext sysContext = this.framework.getBundleContext();
            MBeanServer mbeanServer = (MBeanServer)this.injectedMBeanServer.getValue();
            sysContext.registerService(MBeanServer.class.getName(), (Object)mbeanServer, null);
            SynchronousBundleListener uninstallListener = new SynchronousBundleListener(){

                public void bundleChanged(BundleEvent event) {
                    if (event.getType() == 16) {
                        ServiceController controller;
                        AbstractUserBundle userBundle;
                        try {
                            userBundle = AbstractUserBundle.assertBundleState((Bundle)event.getBundle());
                        }
                        catch (RuntimeException ex) {
                            return;
                        }
                        Deployment deployment = userBundle.getDeployment();
                        ServiceName serviceName = (ServiceName)deployment.getAttachment(ServiceName.class);
                        if (serviceName != null && (controller = serviceContainer.getService(serviceName)) != null) {
                            controller.setMode(ServiceController.Mode.REMOVE);
                        }
                    }
                }
            };
            sysContext.addBundleListener((BundleListener)uninstallListener);
            ArrayList<Deployment> deployments = new ArrayList<Deployment>();
            BundleDeploymentPlugin depPlugin = (BundleDeploymentPlugin)bundleManager.getPlugin(BundleDeploymentPlugin.class);
            for (OSGiSubsystemState.OSGiModule module : ((Configuration)this.injectedConfig.getValue()).getModules()) {
                ModuleIdentifier identifier = module.getIdentifier();
                Deployment dep = depPlugin.createDeployment(identifier);
                dep.setAutoStart(module.isStart());
                deployments.add(dep);
            }
            ServiceReference sref = sysContext.getServiceReference(DeployerService.class.getName());
            DeployerService service = (DeployerService)sysContext.getService(sref);
            service.deploy(deployments.toArray(new Deployment[deployments.size()]));
        }
        catch (Throwable t) {
            throw new StartException("Failed to start OSGi Framework: " + this.framework, t);
        }
    }

    public synchronized void stop(StopContext context) {
        log.infof("Stopping OSGi Framework", new Object[0]);
        if (this.framework != null) {
            try {
                this.framework.stop();
                this.framework.waitForStop(2000L);
            }
            catch (Exception ex) {
                log.errorf((Throwable)ex, "Cannot stop OSGi Framework", new Object[0]);
            }
        }
    }

    public BundleContext getValue() throws IllegalStateException {
        if (this.framework == null || this.framework.getState() != 32) {
            throw new IllegalStateException("Cannot get BundleContext for: " + this.framework);
        }
        return this.framework.getBundleContext();
    }
}

